# MUST (Marmot Umpire Scalable Tool)

MUST automatically checks parallel applications for correct use of MPI. 
It operates at runtime and intercepts all MPI calls that an application 
issues to verify their correctness. It uses the Generic Tool 
Infrastructure (GTI), and PnMPI as base packages.

The MUST documentation is located at doc/manual/manual.pdf.

## Quickstart

### Usage
To execute an application with MUST, `mustrun` can be used as a drop-in
replacement for `mpirun`, e.g. `mpirun -np 4 app.exe` becomes
`mustrun -np 4 app.exe`.

`mustrun` accepts various command line options that all have the prefix `--must:`.
For a complete list of available options for `mustrun`, execute
`mustrun --must:help` or see MUST's documentation.

One common option is the mpiexec command used to launch MPI applications. E.g.,
the following command can be used to use `srun` used instead of `mpirun` 

```
mustrun --must:mpiexec srun --must:np -n -n 4 app.exe
```

MUST also has support for hybrid applications that are multi-threaded.
Use the `--must:hybrid` option to enable support for multi-threaded applications.

### Building MUST

MUST is built using CMake

```
cmake -S MUST -B build -DCMAKE_INSTALL_PREFIX=<must-install-dir>
cmake --build build --target install install-prebuilds -- -j8
export PATH=<must-install-dir>/bin:$PATH
```

The table below lists a subset of build options ( add them as`-D<OPTION>=<Value>` to the first cmake call).

#### Build options

| Option                        | Default | Description                                         |
|-------------------------------|:-------:|-----------------------------------------------------|
| `ENABLE_TESTS`                | `OFF`      | Enable test execution via CMake                  |
| `MPIEXEC_EXECUTABLE`          | `$MPIEXEC` | Executable for running MPI programs              |
| `ENABLE_TSAN`                 | `ON`       | Enable data race analysis with ThreadSanitizer   |
| `ENABLE_TYPEART`              | `ON`       | Enable type matching analysis with TypeART       |

For more information on toggling certain feature see MUSTS's documentation.

#### Test MUST

Testing requires MUST being already installed and the build directory.
Execute a minimal set of tests with

```
cmake --build build -- -j8 check-minimal
```

Or run all tests with the `check` target.

## Publications

- *Tobias Hilbrich, Joachim Protze, Martin Schulz, Bronis R. de Supinski, Matthias S. Müller:* **MPI runtime error detection with MUST: Advances in deadlock detection**. Sci. Program. 21(3-4) (2013)
- *Tobias Hilbrich, Martin Schulz, Holger Brunst, Joachim Protze, Bronis R. de Supinski, Matthias S. Müller:* **Event-Action Mappings for Parallel Tools Infrastructures**. Euro-Par 2015
- *Tobias Hilbrich, Matthias Weber, Joachim Protze, Bronis R. de Supinski, Wolfgang E. Nagel:* **Runtime Correctness Analysis of MPI-3 Nonblocking Collectives**. EuroMPI 2016
- *Simon Schwitanski, Joachim Jenke, Felix Tomski, Christian Terboven, Matthias S. Müller:*
**On-the-Fly Data Race Detection for MPI RMA Programs with MUST**. Correctness@SC 2022

## License

The license file is located directly in this package, named LICENSE.
