
macro (get_variable_int var output)
    string(TOLOWER "${var}" lvar)
    string(REGEX MATCH "int ${lvar} = [^;]+;" assignment "${output}")
    string(REGEX REPLACE "int ${lvar} = ([^;]+);" "\\1" MUST_${var} "${assignment}")
    unset(lvar)
    unset(assignment)
endmacro()

macro (get_variable_string var output)
    string(TOLOWER "${var}" lvar)
    string(REGEX MATCH "char ${lvar}\\[\\] = \"([^\"]+)\";" assignment "${output}")
    string(REGEX REPLACE "char ${lvar}\\[\\] = \"([^\"]+)\";" "\\1" MUST_${var} "${assignment}")
    unset(lvar)
    unset(assignment)
endmacro()

macro (set_must_test_features)
    string(REGEX MATCH "[0-9]+" major "${CMAKE_C_COMPILER_VERSION}")
    string(REGEX MATCH "[0-9]+\\.[0-9]+" majorminor "${CMAKE_C_COMPILER_VERSION}")
    if ("${CMAKE_C_COMPILER_ID}" STREQUAL "GNU")
        set(comp "gcc")
    elseif ("${CMAKE_C_COMPILER_ID}" STREQUAL "Intel")
        set(comp "icc")
    else()
        # Just use the lowercase of the compiler ID as fallback.
        string(TOLOWER "${CMAKE_C_COMPILER_ID}" comp)
    endif()
    set(MUST_TEST_COMPILER_FEATURE_LIST ${comp} ${comp}-${major} ${comp}-${majorminor} ${comp}-${CMAKE_C_COMPILER_VERSION} )

    execute_process(
        COMMAND         bash "-c" "${CMAKE_C_COMPILER} -I${MPI_C_HEADER_DIR} -E -P ${MUST_SOURCE_DIR}/cmakemodules/mpi_implementation_version.c | sed -n '/int main/,$p'"
        OUTPUT_VARIABLE mpi_implementation_version_output
    )

    get_variable_int(MPI_VERSION "${mpi_implementation_version_output}")
    get_variable_int(MPI_SUBVERSION "${mpi_implementation_version_output}")

    get_variable_string(I_MPI_VERSION "${mpi_implementation_version_output}")
    if(MUST_I_MPI_VERSION)
        string(REGEX MATCH "[0-9]+" major "${MUST_I_MPI_VERSION}")
        string(REGEX MATCH "[0-9]+\\.[0-9]+" majorminor "${MUST_I_MPI_VERSION}")
        set(fullversion "${MUST_I_MPI_VERSION}")
        list(APPEND MUST_TEST_MPI_FEATURE_LIST "impi" "impi-${major}" "impi-${majorminor}" "impi-${fullversion}")
    endif()

    get_variable_string(MPICH_VERSION "${mpi_implementation_version_output}")
    if(MUST_MPICH_VERSION)
        string(REGEX MATCH "[0-9]+" major "${MUST_MPICH_VERSION}")
        string(REGEX MATCH "[0-9]+\\.[0-9]+" majorminor "${MUST_MPICH_VERSION}")
        set(fullversion "${MUST_MPICH_VERSION}")
        list(APPEND MUST_TEST_MPI_FEATURE_LIST "mpich" "mpich-${major}" "mpich-${majorminor}" "mpich-${fullversion}")
    endif()

    get_variable_int(OMPI_MAJOR_VERSION "${mpi_implementation_version_output}")
    if(MUST_OMPI_MAJOR_VERSION)
        get_variable_int(OMPI_MINOR_VERSION "${mpi_implementation_version_output}")
        get_variable_int(OMPI_RELEASE_VERSION "${mpi_implementation_version_output}")
        set(major "${MUST_OMPI_MAJOR_VERSION}")
        set(majorminor "${major}.${MUST_OMPI_MINOR_VERSION}")
        set(fullversion "${majorminor}.${MUST_OMPI_RELEASE_VERSION}")
        list(APPEND MUST_TEST_MPI_FEATURE_LIST "ompi" "ompi-${major}" "ompi-${majorminor}" "ompi-${fullversion}")
    endif()
    unset(mpi_implementation_version_output)
    unset(comp)
    unset(major)
    unset(majorminor)
    unset(fullversion)

    list(REMOVE_DUPLICATES MUST_TEST_COMPILER_FEATURE_LIST)
    set(MUST_TEST_COMPILER_FEATURES "[]")
    if(MUST_TEST_COMPILER_FEATURE_LIST)
        list(JOIN MUST_TEST_COMPILER_FEATURE_LIST "\", \"" MUST_TEST_COMPILER_FEATURES)
        set(MUST_TEST_COMPILER_FEATURES "[\"${MUST_TEST_COMPILER_FEATURES}\"]")
    endif()
    unset(MUST_TEST_COMPILER_FEATURE_LIST)
    message(STATUS "MUST_TEST_COMPILER_FEATURES = ${MUST_TEST_COMPILER_FEATURES}")

    list(REMOVE_DUPLICATES MUST_TEST_MPI_FEATURE_LIST)
    set(MUST_TEST_MPI_FEATURES "[]")
    if(MUST_TEST_MPI_FEATURE_LIST)
        list(JOIN MUST_TEST_MPI_FEATURE_LIST "\", \"" MUST_TEST_MPI_FEATURES)
        set(MUST_TEST_MPI_FEATURES "[\"${MUST_TEST_MPI_FEATURES}\"]")
    endif()
    unset(MUST_TEST_MPI_FEATURE_LIST)
    message(STATUS "MUST_TEST_MPI_FEATURES = ${MUST_TEST_MPI_FEATURES}")
endmacro()