/* This file is part of GTI (Generic Tool Infrastructure)
 *
 * Copyright (C)
 *  2008-2019 ZIH, Technische Universitaet Dresden, Federal Republic of Germany
 *  2008-2019 Lawrence Livermore National Laboratories, United States of America
 *  2013-2023 RWTH Aachen University, Federal Republic of Germany
 *
 * See the LICENSE file in the package base directory for details
 */

/**
 * @file CProtMpiSplitWorld.h
 *
 *  @date 04.12.23
 *  @author Sebastian Grabowski
 */

#ifndef GTI_MODULES_COMM_PROTOCOLS_CPROTMPISPLITWORLD_H
#define GTI_MODULES_COMM_PROTOCOLS_CPROTMPISPLITWORLD_H

#include <mpi.h>

/**
 * Get the intracommunicator for the layer that the current rank is in. This means especially the
 * replacement communicator for MPI_COMM_WORLD on the application layer.
 *
 * \param[out] comm the communicator for this layer
 */
extern "C" int getMySetComm(MPI_Comm* comm);

#endif // GTI_MODULES_COMM_PROTOCOLS_CPROTMPISPLITWORLD_H
