/* This file is part of GTI (Generic Tool Infrastructure)
 *
 * Copyright (C)
 *  2008-2019 ZIH, Technische Universitaet Dresden, Federal Republic of Germany
 *  2008-2019 Lawrence Livermore National Laboratories, United States of America
 *  2013-2023 RWTH Aachen University, Federal Republic of Germany
 *
 * See the LICENSE file in the package base directory for details
 */

/**
 * @file CProtMpiSplitWorld.w
 * This is the source for the generated part included by CProtMpiSplitWorld.cpp. 
 */

{{fn fn_name MPI_Init MPI_Init_thread}} {
    int err = MPI_SUCCESS;

    PNMPI_modHandle_t stack = 0;
    err = PNMPI_Service_GetStackByName("level_0", &stack);
    assert(err == PNMPI_SUCCESS);
    extern int X{{fn_name}}_NewStack({{list "int stack" {{formals}}}});
    err = X{{fn_name}}_NewStack({{list stack{{args}}}});

#ifdef MUST_TIME
    gettimeofday(&gStart, NULL);
#endif
    
    gti::crashHandlingInit();
    gti::crashHandlingInitErrhandlers();
    gti::crashHandlingInitWorldModel();
    if (!::gModuleInitialized) {
        ::usingWorldModel = true;
        MPI_Comm commWorld = MPI_COMM_NULL;
        err = XMPI_Comm_dup_NewStack(stack, MPI_COMM_WORLD, &commWorld);
        assert(err == MPI_SUCCESS);
        MPI_Comm commSelf = MPI_COMM_NULL;
        err = XMPI_Comm_dup_NewStack(stack, MPI_COMM_SELF, &commSelf);
        assert(err == MPI_SUCCESS);
        
        init(commWorld, commSelf);
    }

    const auto &mySet = getMyMpiSet();
    if (mySet.app_place) {
        // APPLICATION
        extern int X{{fn_name}}({{formals}});
        err = X{{fn_name}}({{args}});
        assert(err == MPI_SUCCESS);
    } else {
        // Tool Processes
        runTool({{list mySet.stack{{args}}}});
    }

    return err;
}
{{endfn}}
