/* This file is part of GTI (Generic Tool Infrastructure)
 *
 * Copyright (C)
 *  2008-2019 ZIH, Technische Universitaet Dresden, Federal Republic of Germany
 *  2008-2019 Lawrence Livermore National Laboratories, United States of America
 *  2013-2019 RWTH Aachen University, Federal Republic of Germany
 *
 * See the LICENSE file in the package base directory for details
 */

/**
 * @file CStratCrashHandling.w
 * This is the source for the generated part included by CStratCrashHandling.cpp. 
 */

extern "C" {

// Special handling of calls that receive a default errorhandler argument
{{fnalltype fn_name MPI_Comm* MPI_Comm_free MPI_Comm_disconnect MPI_Comm_idup}} {
 WRAP_MPI_CALL_PREFIX
   {{ret_val}} = X{{fn_name}}({{args}});
 WRAP_MPI_CALL_POSTFIX
   {{apply_to_type MPI_Comm* GTI_COMM_SET_ERR_HANDLER}}
}{{endfnalltype}}

{{fnalltype fn_name MPI_Win* MPI_Win_free}} {
 WRAP_MPI_CALL_PREFIX
   {{ret_val}} = X{{fn_name}}({{args}});
 WRAP_MPI_CALL_POSTFIX
   {{apply_to_type MPI_Win* GTI_WIN_SET_ERR_HANDLER}}
}{{endfnalltype}}

{{fnalltype fn_name MPI_File* MPI_File_close}} {
 WRAP_MPI_CALL_PREFIX
   {{ret_val}} = X{{fn_name}}({{args}});
 WRAP_MPI_CALL_POSTFIX
   {{apply_to_type MPI_File* GTI_FILE_SET_ERR_HANDLER}}
}{{endfnalltype}}

#if defined(GTI_ENABLE_SESSIONS)
{{fnalltype fn_name MPI_Session* MPI_Session_finalize}} {
   WRAP_MPI_CALL_PREFIX
       {{ret_val}} = X{{fn_name}}({{args}});
   WRAP_MPI_CALL_POSTFIX
   auto const attach_errhandler = [](MPI_Session* session) {
       XMPI_Session_set_errhandler_NewStack(::stack, *session, gti::getSessionErrhandler());
   };
   {{apply_to_type MPI_Session* attach_errhandler}}
}{{endfnalltype}}
#endif

// create errhandler functions
{{fn fn_name MPI_Comm_create_errhandler MPI_Session_create_errhandler MPI_Win_create_errhandler MPI_File_create_errhandler }} {
    WRAP_MPI_CALL_PREFIX
        {{ret_val}} = X{{fn_name}}({{args}});
    WRAP_MPI_CALL_POSTFIX
    {{sub {{fn_name}} 'MPI_(.+)_create_errhandler' '\1'}}ErrhandlerTracker.add({{0}}, *{{1}});
}{{endfn}}

static void hideCommWorld(MPI_Comm& comm) {
    if (comm == MPI_COMM_WORLD) {
        getMySetComm(&comm);
    }
};

// set errhandler functions
{{fn fn_name MPI_Comm_set_errhandler MPI_Session_set_errhandler MPI_File_set_errhandler MPI_Win_set_errhandler}} {
    warn_if_errors_return_handler({{1}});
    
    // MPI_Comm gets a special treatment: replace MPI_COMM_WORLD argument with replacement communicator
    {{applyToType MPI_Comm hideCommWorld}}
    
    // Extract the type from the function name, e.g. MPI_Comm_set_errhandler is substituted with Comm
    {{sub {{types 0}} '^MPI_' ''}}ErrhandlerTracker.attach({{0}}, {{1}});
    {{ret_val}} = MPI_SUCCESS;
}{{endfn}}

// get errhandler functions
{{fn fn_name MPI_Comm_get_errhandler MPI_Session_get_errhandler MPI_Win_get_errhandler MPI_File_get_errhandler}} {
    // MPI_Comm gets a special treatment: replace MPI_COMM_WORLD argument with replacement communicator
    {{applyToType MPI_Comm hideCommWorld}}
    
    // Extract the type from the function name, e.g. MPI_Comm_set_errhandler is substituted with Comm
    MPI_Errhandler errh = 
        {{sub {{types 0}} '^MPI_' ''}}ErrhandlerTracker.getErrhandler({{0}}); 
    if (errh != MPI_ERRHANDLER_NULL) {
        // Omitting the call to the MPI library breaks refcounting with
        // MPI_Errhandler_free. We track the amount of calls to the library
        // that were prevented here.
        sf::xlock_safe_ptr(omittedGetErrhandlerCalls)->operator[](errh) += 1;
        *{{1}} = errh;
        {{ret_val}} = MPI_SUCCESS;
    } else {
        WRAP_MPI_CALL_PREFIX
            {{ret_val}} = X{{fn_name}}({{args}});
        WRAP_MPI_CALL_POSTFIX
    }
}{{endfn}}

{{fn fn_name MPI_Errhandler_free}} {
    auto xptr = sf::xlock_safe_ptr(omittedGetErrhandlerCalls);
    auto& omitted = xptr->operator[](*{{0}});
    if (omitted < 1) {
        {{ret_val}} = X{{fn_name}}({{args}});
    } else {
        // Simulate the call to the mpi library to mirror omitted calls in the
        // MPI_xxx_get_errhandler wrapper
        omitted -= 1;
        *{{0}} = MPI_ERRHANDLER_NULL;
        {{ret_val}} = MPI_SUCCESS;
    }
}{{endfn}}

}
