/* This file is part of GTI (Generic Tool Infrastructure)
 *
 * Copyright (C)
 *  2008-2019 ZIH, Technische Universitaet Dresden, Federal Republic of Germany
 *  2008-2019 Lawrence Livermore National Laboratories, United States of America
 *  2013-2023 RWTH Aachen University, Federal Republic of Germany
 *
 * See the LICENSE file in the package base directory for details
 */

/**
 * @file I_Startup.h
 *
 * Interface for a reduction on the MPI Initialization. Used to notify the tree of applications
 * doing MPI World Model initializations.
 *
 *  @date 18.07.23
 *  @author Sebastian Grabowski
 */

#ifndef GTI_MODULES_GTI_INTERNAL_I_INITREDUCTION_H
#define GTI_MODULES_GTI_INTERNAL_I_INITREDUCTION_H

#include <list>

#include "I_ChannelId.h"
#include "I_Module.h"
#include "I_Reduction.h"

namespace gti
{

class I_InitReduction : public I_Module, public I_Reduction
{
  public:
    virtual GTI_ANALYSIS_RETURN
    reduce(I_ChannelId* thisChannel, std::list<I_ChannelId*>* outFinishedChannels) = 0;

    /**
     * The timeout function, see gti::I_Reduction.timeout
     */
    virtual void timeout() = 0;
};

} // namespace gti

#endif // GTI_MODULES_GTI_INTERNAL_I_INITREDUCTION_H
