/* This file is part of GTI (Generic Tool Infrastructure)
 *
 * Copyright (C)
 *  2008-2019 ZIH, Technische Universitaet Dresden, Federal Republic of Germany
 *  2008-2019 Lawrence Livermore National Laboratories, United States of America
 *  2013-2023 RWTH Aachen University, Federal Republic of Germany
 *
 * See the LICENSE file in the package base directory for details
 */

/**
 * @file I_StartupReceiver.h
 *
 * Interface for a GTI Module that gets notified when the world model gets initialized.
 *
 *
 *  @date 18.07.23
 *  @author Sebastian Grabowski
 */

#ifndef GTI_MODULES_GTI_INTERNAL_I_STARTUPRECEIVER_H
#define GTI_MODULES_GTI_INTERNAL_I_STARTUPRECEIVER_H

#include "I_Module.h"
#include "I_InitReduction.h"

namespace gti
{

class I_StartupReceiver : public gti::I_Module
{
  public:
    /**
     * Notify the registered handler of the MPI initialization.
     */
    virtual GTI_ANALYSIS_RETURN init() = 0;
};

} // namespace gti

#endif // GTI_MODULES_GTI_INTERNAL_I_STARTUPRECEIVER_H
