/**
 * @file Startup.cpp
 *
 *  @date 18.07.23
 *  @author Sebastian Grabowski
 */

#include "InitReduction.h"

#include <memory>

#include "GtiMacros.h"
#include "CompletionTree.h"

using namespace gti;

mGET_INSTANCE_FUNCTION(InitReduction);
mFREE_INSTANCE_FUNCTION(InitReduction);
mPNMPI_REGISTRATIONPOINT_FUNCTION(InitReduction);

InitReduction::InitReduction(const char* instanceName) : ModuleBase(instanceName)
{
    // create sub modules
    createSubModuleInstances();
}

GTI_ANALYSIS_RETURN
InitReduction::reduce(
    gti::I_ChannelId* thisChannel,
    std::list<gti::I_ChannelId*>* outFinishedChannels)
{
    for (auto iter = myTimedOutReductions.begin(); iter != myTimedOutReductions.end(); ++iter) {
        auto& timedOutReduction = *iter;

        if (!timedOutReduction->wasCompleted(thisChannel)) {
            timedOutReduction->addCompletion(thisChannel);

            if (timedOutReduction->isCompleted()) {
                myTimedOutReductions.erase(iter);
            }

            return GTI_ANALYSIS_IRREDUCIBLE;
        }
    }

    if (!myCompletion) {
        myCompletion = std::unique_ptr<CompletionTree>{new CompletionTree(
            thisChannel->getNumUsedSubIds() - 1,
            thisChannel->getSubIdNumChannels(thisChannel->getNumUsedSubIds() - 1))};
    }

    if (myReductionPartners.empty()) {
        // This is the first call of the reduction.
        int (*notify_fptr)() = nullptr;
        if (getWrapperFunction("gtiInitNotify", reinterpret_cast<GTI_Fct_t*>(&notify_fptr)) ==
            GTI_SUCCESS) {
            (*notify_fptr)();
        } else {
            return GTI_ANALYSIS_FAILURE;
        }
    }

    myCompletion->addCompletion(thisChannel);
    if (myCompletion->isCompleted()) {
        for (auto& partner : myReductionPartners) {
            outFinishedChannels->push_back(partner.release());
        }
        myReductionPartners.clear();
        myCompletion->flushCompletions();

        return GTI_ANALYSIS_SUCCESS;
    }

    myReductionPartners.emplace_back(thisChannel);
    return GTI_ANALYSIS_WAITING;
}

void InitReduction::timeout()
{
    if (!myReductionPartners.empty()) {
        myReductionPartners.clear();

        if (myCompletion) {
            myTimedOutReductions.emplace_back(myCompletion.release());
        }
    }
}
