/**
 * @file Startup.h
 *
 *  @date 18.07.23
 *  @author Sebastian Grabowski
 */

#ifndef GTI_MODULES_GTI_INTERNAL_INITREDUCTION_H
#define GTI_MODULES_GTI_INTERNAL_INITREDUCTION_H

#include "I_InitReduction.h"

#include "ModuleBase.h"
#include "CompletionTree.h"

namespace gti
{

class InitReduction : public gti::ModuleBase<InitReduction, I_InitReduction>
{
  public:
    /**
     * Constructor.
     * @param instanceName name of this module instance.
     */
    InitReduction(const char* instanceName);

    InitReduction(InitReduction const&) = delete;
    InitReduction(InitReduction&&) = delete;
    InitReduction& operator=(InitReduction const&) = delete;
    InitReduction& operator=(InitReduction&&) = delete;

    /**
     * Destructor.
     */
    ~InitReduction() override = default;

    /**
     * @copydoc I_InitReduction::reduce
     */
    GTI_ANALYSIS_RETURN
    reduce(gti::I_ChannelId* thisChannel, std::list<gti::I_ChannelId*>* outFinishedChannels)
        override;

    /**
     * @copydoc I_InitReduction::timeout
     */
    void timeout() override;

  private:
    std::unique_ptr<CompletionTree> myCompletion{nullptr};
    std::vector<std::unique_ptr<I_ChannelId>> myReductionPartners{};
    std::vector<std::unique_ptr<CompletionTree>> myTimedOutReductions{};
};

} // namespace gti

#endif // GTI_MODULES_GTI_INTERNAL_INITREDUCTION_H
