/**
 * @file StartupReciever.cpp
 *
 *  @date 18.07.23
 *  @author Sebastian Grabowski
 */

#include "StartupReceiver.h"

#include <cstdio>
#include <cassert>
#include <mutex>
#include "GtiMacros.h"

using namespace gti;

mGET_INSTANCE_FUNCTION(StartupReceiver);
mFREE_INSTANCE_FUNCTION(StartupReceiver);
mPNMPI_REGISTRATIONPOINT_FUNCTION(StartupReceiver);

StartupReceiver::InitHandler_t* StartupReceiver::init_handler = [] {};

StartupReceiver::StartupReceiver(const char* instanceName) : ModuleBase(instanceName)
{
    // create sub modules
    createSubModuleInstances();
}

GTI_ANALYSIS_RETURN StartupReceiver::init()
{
    init_handler();
    return GTI_ANALYSIS_SUCCESS;
}

void StartupReceiver::on_init(StartupReceiver::InitHandler_t* handler) { init_handler = handler; }

/**
 * Registers the modules `OnInit` service.
 */
extern "C" void PNMPI_Init()
{
    static std::once_flag flag;
    std::call_once(flag, []() {
        PNMPI_Service_descriptor_t service;
        std::sprintf(service.name, "OnInit");
        service.fct = (PNMPI_Service_Fct_t)StartupReceiver::on_init;
        std::sprintf(service.sig, "p");
#if !defined(NDEBUG)
        int err =
#endif
            PNMPI_Service_RegisterService(&service);
        assert(err == PNMPI_SUCCESS);
    });
}
