/**
 * @file StartupReceiver.h
 *
 *  @date 18.07.23
 *  @author Sebastian Grabowski
 */

#ifndef GTI_MODULES_GTI_INTERNAL_STARTUPRECEIVER_H
#define GTI_MODULES_GTI_INTERNAL_STARTUPRECEIVER_H

#include "I_StartupReceiver.h"

#include "ModuleBase.h"

namespace gti
{

class StartupReceiver : public gti::ModuleBase<StartupReceiver, I_StartupReceiver>
{
  public:
    using InitHandler_t = void();

    /**
     * Constructor.
     * @param instanceName name of this module instance.
     */
    StartupReceiver(const char* instanceName);

    StartupReceiver(StartupReceiver const&) = delete;
    StartupReceiver(StartupReceiver&&) = delete;
    StartupReceiver& operator=(StartupReceiver const&) = delete;
    StartupReceiver& operator=(StartupReceiver&&) = delete;

    /**
     * Destructor.
     */
    ~StartupReceiver() override = default;

    /** Register a callback that gets notified on initialization. */
    static void on_init(InitHandler_t*);

    /**
     * @copydoc I_StartUpReceiver::init()
     */
    GTI_ANALYSIS_RETURN init() override;

  private:
    /** The callback to notify of an MPI Init. */
    static InitHandler_t* init_handler;
};

} // namespace gti

#endif // GTI_MODULES_GTI_INTERNAL_STARTUPRECEIVER_H
