/* This file is part of GTI (Generic Tool Infrastructure)
 *
 * Copyright (C)
 *  2008-2019 ZIH, Technische Universitaet Dresden, Federal Republic of Germany
 *  2008-2019 Lawrence Livermore National Laboratories, United States of America
 *  2013-2023 RWTH Aachen University, Federal Republic of Germany
 *
 * See the LICENSE file in the package base directory for details
 */

/**
 * @file Comm.c
 *
 * @author Sebastian Grabowski
 */

#include <mpi.h>
#include <stdio.h>

void MyCommErrhandler(MPI_Comm* comm, int* errorcode, ...)
{
    printf("MyCommErrhandler was called!\n");
}

int main(int argc, char** argv)
{
    int provided = -1;
    MPI_Init_thread(&argc, &argv, MPI_THREAD_SINGLE, &provided);

    MPI_Errhandler handler = MPI_ERRHANDLER_NULL;
    MPI_Comm_create_errhandler(MyCommErrhandler, &handler);

    MPI_Comm_set_errhandler(MPI_COMM_WORLD, handler);

    MPI_Comm_call_errhandler(MPI_COMM_WORLD, MPI_SUCCESS);

    MPI_Errhandler_free(&handler);
    MPI_Finalize();
    return 0;
}
