/* This file is part of GTI (Generic Tool Infrastructure)
 *
 * Copyright (C)
 *  2008-2019 ZIH, Technische Universitaet Dresden, Federal Republic of Germany
 *  2008-2019 Lawrence Livermore National Laboratories, United States of America
 *  2013-2023 RWTH Aachen University, Federal Republic of Germany
 *
 * See the LICENSE file in the package base directory for details
 */

/**
 * @file Session.c
 *
 * @author Sebastian Grabowski
 */

#include <mpi.h>
#include <stdio.h>

void MySessionErrhandler(MPI_Session* session, int* errorcode, ...)
{
    printf("MySessionErrhandler was called!\n");
}

int main(int argc, char** argv)
{
    MPI_Session session = MPI_SESSION_NULL;
    MPI_Session_init(MPI_INFO_NULL, MPI_ERRORS_RETURN, &session);

    MPI_Errhandler handler = MPI_ERRHANDLER_NULL;
    MPI_Session_create_errhandler(MySessionErrhandler, &handler);
    MPI_Session_set_errhandler(session, handler);

    MPI_Errhandler handler_retrieved = MPI_ERRHANDLER_NULL;
    MPI_Session_get_errhandler(session, &handler_retrieved);
    MPI_Errhandler_free(&handler_retrieved);

    MPI_Session_call_errhandler(session, MPI_SUCCESS);

    MPI_Errhandler_free(&handler);
    MPI_Session_finalize(&session);
    return 0;
}
