/* This file is part of GTI (Generic Tool Infrastructure)
 *
 * Copyright (C)
 *  2008-2019 ZIH, Technische Universitaet Dresden, Federal Republic of Germany
 *  2008-2019 Lawrence Livermore National Laboratories, United States of America
 *  2013-2023 RWTH Aachen University, Federal Republic of Germany
 *
 * See the LICENSE file in the package base directory for details
 */

/**
 * @file hello_session.c
 * A GTI hello world test using MPI Sessions.
 * Contains no errors.
 *
 * @author Sebastian Grabowski
 */

#include <mpi.h>
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char** argv)
{
    int rank, size;

    MPI_Init(&argc, &argv);

    MPI_Session session = MPI_SESSION_NULL;
    MPI_Session_init(MPI_INFO_NULL, MPI_ERRORS_ARE_FATAL, &session);
    MPI_Group group = MPI_GROUP_NULL;
    MPI_Group_from_session_pset(session, "mpi://WORLD", &group);

    MPI_Comm session_comm = MPI_COMM_NULL;
    MPI_Comm_create_from_group(
        group,
        "hello.session",
        MPI_INFO_NULL,
        MPI_ERRORS_ARE_FATAL,
        &session_comm);

    int session_rank = -1;
    MPI_Comm_rank(session_comm, &session_rank);
    int session_size = -1;
    MPI_Comm_size(session_comm, &session_size);

    printf(
        "Hello! I am %d of %d tasks in the group built from mpi://WORLD\n",
        session_rank,
        session_size);

    MPI_Info pset_info = MPI_INFO_NULL;
    MPI_Session_get_pset_info(session, "mpi://WORLD", &pset_info);
    int present = 0;
    int buflen = 20;
    char buf[20] = {'0'};
    MPI_Info_get_string(pset_info, "mpi_size", &buflen, buf, &present);

    printf("The size of mpi://WORLD is %s\n", buf);

    MPI_Info_free(&pset_info);

    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    printf("Hello, I am %d of %d tasks.\n", rank, size);

    MPI_Comm_free(&session_comm);
    MPI_Group_free(&group);
    MPI_Session_finalize(&session);

    MPI_Finalize();

    return 0;
}
