#ifndef NOTOOL

#include <assert.h>
#include <mpi.h>
#include <stdio.h>

#include "tracking.h"

extern "C" {
/* ================== C Wrappers for MPI_Alltoallw ================== */
int PMPI_Alltoallw(const void *sendbuf, const int sendcounts[],
                   const int sdispls[], const MPI_Datatype sendtypes[],
                   void *recvbuf, const int recvcounts[], const int rdispls[],
                   const MPI_Datatype recvtypes[], MPI_Comm comm);
int MPI_Alltoallw(const void *sendbuf, const int sendcounts[],
                  const int sdispls[], const MPI_Datatype sendtypes[],
                  void *recvbuf, const int recvcounts[], const int rdispls[],
                  const MPI_Datatype recvtypes[], MPI_Comm comm) {
  int _wrap_py_return_val = 0;

  preComm(comm);
#ifdef HANDLE_TYPE
  int comm_size;
  PMPI_Comm_size(comm, &comm_size);
  MPI_Datatype mySTypes[comm_size], myRTypes[comm_size];
  for (int i = 0; i < comm_size; i++) {
    mySTypes[i] = tf.getHandle(sendtypes[i]);
    myRTypes[i] = tf.getHandle(recvtypes[i]);
  }
#else
  const MPI_Datatype *mySTypes = sendtypes;
  const MPI_Datatype *myRTypes = recvtypes;
#endif
  _wrap_py_return_val =
      PMPI_Alltoallw(sendbuf, sendcounts, sdispls, mySTypes, recvbuf,
                     recvcounts, rdispls, myRTypes, comm);

  return _wrap_py_return_val;
}

/* ================== C Wrappers for MPI_Neighbor_alltoallw ==================
 */
int PMPI_Neighbor_alltoallw(const void *sendbuf, const int sendcounts[],
                            const MPI_Aint sdispls[],
                            const MPI_Datatype sendtypes[], void *recvbuf,
                            const int recvcounts[], const MPI_Aint rdispls[],
                            const MPI_Datatype recvtypes[], MPI_Comm comm);
int MPI_Neighbor_alltoallw(const void *sendbuf, const int sendcounts[],
                           const MPI_Aint sdispls[],
                           const MPI_Datatype sendtypes[], void *recvbuf,
                           const int recvcounts[], const MPI_Aint rdispls[],
                           const MPI_Datatype recvtypes[], MPI_Comm comm) {
  int _wrap_py_return_val = 0;

  preComm(comm);
#ifdef HANDLE_TYPE
  int comm_size;
  PMPI_Comm_size(comm, &comm_size);
  MPI_Datatype mySTypes[comm_size], myRTypes[comm_size];
  for (int i = 0; i < comm_size; i++) {
    mySTypes[i] = tf.getHandle(sendtypes[i]);
    myRTypes[i] = tf.getHandle(recvtypes[i]);
  }
#else
  const MPI_Datatype *mySTypes = sendtypes;
  const MPI_Datatype *myRTypes = recvtypes;
#endif
  _wrap_py_return_val =
      PMPI_Neighbor_alltoallw(sendbuf, sendcounts, sdispls, mySTypes, recvbuf,
                              recvcounts, rdispls, myRTypes, comm);

  return _wrap_py_return_val;
}

/* ================== C Wrappers for MPI_Type_create_struct ==================
 */
#ifdef HANDLE_TYPE
int PMPI_Type_create_struct(int count, const int array_of_blocklengths[],
                            const MPI_Aint array_of_displacements[],
                            const MPI_Datatype array_of_types[],
                            MPI_Datatype *newtype);
int MPI_Type_create_struct(int count, const int array_of_blocklengths[],
                           const MPI_Aint array_of_displacements[],
                           const MPI_Datatype array_of_types[],
                           MPI_Datatype *newtype) {
  int _wrap_py_return_val = 0;
  MPI_Datatype myTypes[count];
  for (int i = 0; i < count; i++) {
    myTypes[i] = tf.getHandle(array_of_types[i]);
  }

  _wrap_py_return_val = PMPI_Type_create_struct(
      count, array_of_blocklengths, array_of_displacements, myTypes, newtype);
  postType(newtype);

  return _wrap_py_return_val;
}
#endif

/* ================== C Wrappers for MPI_Type_get_contents ================== */
#ifdef HANDLE_TYPE
int PMPI_Type_get_contents(MPI_Datatype datatype, int max_integers,
                           int max_addresses, int max_datatypes,
                           int array_of_integers[],
                           MPI_Aint array_of_addresses[],
                           MPI_Datatype array_of_datatypes[]);
int MPI_Type_get_contents(MPI_Datatype datatype, int max_integers,
                          int max_addresses, int max_datatypes,
                          int array_of_integers[],
                          MPI_Aint array_of_addresses[],
                          MPI_Datatype array_of_datatypes[]) {
  int _wrap_py_return_val = 0;

  preType(datatype);
  MPI_Datatype myTypes[max_datatypes] = {MPI_DATATYPE_NULL};

  _wrap_py_return_val = PMPI_Type_get_contents(
      datatype, max_integers, max_addresses, max_datatypes, array_of_integers,
      array_of_addresses, myTypes);
  for (int i = 0; i < max_datatypes; i++) {
    array_of_datatypes[i] = tf.newHandle(myTypes[i]);
  }

  return _wrap_py_return_val;
}
#endif

#ifdef HAVE_COUNT
/* ================== C Wrappers for MPI_Type_struct ================== */
#ifdef HANDLE_TYPE
int PMPI_Type_struct(int count, int array_of_blocklengths[],
                     MPI_Aint array_of_displacements[],
                     MPI_Datatype array_of_types[], MPI_Datatype *newtype);
int MPI_Type_struct(int count, int array_of_blocklengths[],
                    MPI_Aint array_of_displacements[],
                    MPI_Datatype array_of_types[], MPI_Datatype *newtype) {
  int _wrap_py_return_val = 0;
  MPI_Datatype myTypes[count];
  for (int i = 0; i < count; i++) {
    myTypes[i] = tf.getHandle(array_of_types[i]);
  }

  _wrap_py_return_val = PMPI_Type_struct(
      count, array_of_blocklengths, array_of_displacements, myTypes, newtype);
  postType(newtype);

  return _wrap_py_return_val;
}
#endif

/* ================== C Wrappers for MPI_Alltoallw_c ================== */
int PMPI_Alltoallw_c(const void *sendbuf, const MPI_Count sendcounts[],
                     const MPI_Aint sdispls[], const MPI_Datatype sendtypes[],
                     void *recvbuf, const MPI_Count recvcounts[],
                     const MPI_Aint rdispls[], const MPI_Datatype recvtypes[],
                     MPI_Comm comm);
int MPI_Alltoallw_c(const void *sendbuf, const MPI_Count sendcounts[],
                    const MPI_Aint sdispls[], const MPI_Datatype sendtypes[],
                    void *recvbuf, const MPI_Count recvcounts[],
                    const MPI_Aint rdispls[], const MPI_Datatype recvtypes[],
                    MPI_Comm comm) {
  int _wrap_py_return_val = 0;

  preComm(comm);
#ifdef HANDLE_TYPE
  int comm_size;
  PMPI_Comm_size(comm, &comm_size);
  MPI_Datatype mySTypes[comm_size], myRTypes[comm_size];
  for (int i = 0; i < comm_size; i++) {
    mySTypes[i] = tf.getHandle(sendtypes[i]);
    myRTypes[i] = tf.getHandle(recvtypes[i]);
  }
#else
  const MPI_Datatype *mySTypes = sendtypes;
  const MPI_Datatype *myRTypes = recvtypes;
#endif

  _wrap_py_return_val =
      PMPI_Alltoallw_c(sendbuf, sendcounts, sdispls, mySTypes, recvbuf,
                       recvcounts, rdispls, myRTypes, comm);

  return _wrap_py_return_val;
}

/* ================== C Wrappers for MPI_Neighbor_alltoallw_c ==================
 */
int PMPI_Neighbor_alltoallw_c(const void *sendbuf, const MPI_Count sendcounts[],
                              const MPI_Aint sdispls[],
                              const MPI_Datatype sendtypes[], void *recvbuf,
                              const MPI_Count recvcounts[],
                              const MPI_Aint rdispls[],
                              const MPI_Datatype recvtypes[], MPI_Comm comm);
int MPI_Neighbor_alltoallw_c(const void *sendbuf, const MPI_Count sendcounts[],
                             const MPI_Aint sdispls[],
                             const MPI_Datatype sendtypes[], void *recvbuf,
                             const MPI_Count recvcounts[],
                             const MPI_Aint rdispls[],
                             const MPI_Datatype recvtypes[], MPI_Comm comm) {
  int _wrap_py_return_val = 0;

  preComm(comm);
#ifdef HANDLE_TYPE
  int comm_size;
  PMPI_Comm_size(comm, &comm_size);
  MPI_Datatype mySTypes[comm_size], myRTypes[comm_size];
  for (int i = 0; i < comm_size; i++) {
    mySTypes[i] = tf.getHandle(sendtypes[i]);
    myRTypes[i] = tf.getHandle(recvtypes[i]);
  }
#else
  const MPI_Datatype *mySTypes = sendtypes;
  const MPI_Datatype *myRTypes = recvtypes;
#endif

  _wrap_py_return_val =
      PMPI_Neighbor_alltoallw_c(sendbuf, sendcounts, sdispls, mySTypes, recvbuf,
                                recvcounts, rdispls, myRTypes, comm);

  return _wrap_py_return_val;
}

/* ================== C Wrappers for MPI_Type_create_struct_c ==================
 */
#ifdef HANDLE_TYPE
int PMPI_Type_create_struct_c(MPI_Count count,
                              const MPI_Count array_of_blocklengths[],
                              const MPI_Count array_of_displacements[],
                              const MPI_Datatype array_of_types[],
                              MPI_Datatype *newtype);
int MPI_Type_create_struct_c(MPI_Count count,
                             const MPI_Count array_of_blocklengths[],
                             const MPI_Count array_of_displacements[],
                             const MPI_Datatype array_of_types[],
                             MPI_Datatype *newtype) {
  int _wrap_py_return_val = 0;
  MPI_Datatype myTypes[count];
  for (int i = 0; i < count; i++) {
    myTypes[i] = tf.getHandle(array_of_types[i]);
  }

  _wrap_py_return_val = PMPI_Type_create_struct_c(
      count, array_of_blocklengths, array_of_displacements, myTypes, newtype);
  postType(newtype);

  return _wrap_py_return_val;
}
#endif

/* ================== C Wrappers for MPI_Type_get_contents_c ==================
 */
#ifdef HANDLE_TYPE
int PMPI_Type_get_contents_c(MPI_Datatype datatype, MPI_Count max_integers,
                             MPI_Count max_addresses,
                             MPI_Count max_large_counts,
                             MPI_Count max_datatypes, int array_of_integers[],
                             MPI_Aint array_of_addresses[],
                             MPI_Count array_of_large_counts[],
                             MPI_Datatype array_of_datatypes[]);
int MPI_Type_get_contents_c(MPI_Datatype datatype, MPI_Count max_integers,
                            MPI_Count max_addresses, MPI_Count max_large_counts,
                            MPI_Count max_datatypes, int array_of_integers[],
                            MPI_Aint array_of_addresses[],
                            MPI_Count array_of_large_counts[],
                            MPI_Datatype array_of_datatypes[]) {
  int _wrap_py_return_val = 0;

  preType(datatype);
  MPI_Datatype myTypes[max_datatypes] = {MPI_DATATYPE_NULL};

  _wrap_py_return_val = PMPI_Type_get_contents_c(
      datatype, max_integers, max_addresses, max_large_counts, max_datatypes,
      array_of_integers, array_of_addresses, array_of_large_counts, myTypes);
  for (int i = 0; i < max_datatypes; i++) {
    array_of_datatypes[i] = tf.newHandle(myTypes[i]);
  }

  return _wrap_py_return_val;
}
#endif
#endif

////////////////////
// FREE functions
////////////////////

/* ================== C Wrappers for MPI_Group_free ================== */
#ifdef HANDLE_GROUP
int PMPI_Group_free(MPI_Group *group);
int MPI_Group_free(MPI_Group *group) {
  int _wrap_py_return_val = 0;

  MPI_Group myGrp = gf.getHandle(*group);
  *group = gf.freeHandle(*group);
  MPI_Group *myGrpP = &myGrp;
  _wrap_py_return_val = PMPI_Group_free(myGrpP);

  return _wrap_py_return_val;
}
#endif

/* ================== C Wrappers for MPI_Op_free ================== */
#ifdef HANDLE_OP
int PMPI_Op_free(MPI_Op *op);
int MPI_Op_free(MPI_Op *op) {
  int _wrap_py_return_val = 0;

  MPI_Op myOp = of.getHandle(*op);
  *op = of.freeHandle(*op);
  MPI_Op *myOpP = &myOp;
  _wrap_py_return_val = PMPI_Op_free(myOpP);

  return _wrap_py_return_val;
}
#endif

/* ================== C Wrappers for MPI_Win_free ================== */
#ifdef HANDLE_WIN
int PMPI_Win_free(MPI_Win *win);
int MPI_Win_free(MPI_Win *win) {
  int _wrap_py_return_val = 0;

  MPI_Win myWin = wf.getHandle(*win);
  *win = wf.freeHandle(*win);
  MPI_Win *myWinP = &myWin;
  _wrap_py_return_val = PMPI_Win_free(myWinP);

  return _wrap_py_return_val;
}
#endif

/* ================== C Wrappers for MPI_Comm_free ================== */
#ifdef HANDLE_COMM
int PMPI_Comm_free(MPI_Comm *comm);
int MPI_Comm_free(MPI_Comm *comm) {
  int _wrap_py_return_val = 0;

  MPI_Comm myComm = cf.getHandle(*comm);
  *comm = cf.freeHandle(*comm);
  MPI_Comm *myCommP = &myComm;
  _wrap_py_return_val = PMPI_Comm_free(myCommP);

  return _wrap_py_return_val;
}
#endif

/* ================== C Wrappers for MPI_Comm_disconnect ================== */
#ifdef HANDLE_COMM
int PMPI_Comm_disconnect(MPI_Comm *comm);
int MPI_Comm_disconnect(MPI_Comm *comm) {
  int _wrap_py_return_val = 0;

  MPI_Comm myComm = cf.getHandle(*comm);
  *comm = cf.freeHandle(*comm);
  MPI_Comm *myCommP = &myComm;
  _wrap_py_return_val = PMPI_Comm_disconnect(myCommP);

  return _wrap_py_return_val;
}
#endif

/* ================== C Wrappers for MPI_Type_free ================== */
#ifdef HANDLE_TYPE
int PMPI_Type_free(MPI_Datatype *datatype);
int MPI_Type_free(MPI_Datatype *datatype) {
  int _wrap_py_return_val = 0;

  MPI_Datatype myType = tf.getHandle(*datatype);
  *datatype = tf.freeHandle(*datatype);
  MPI_Datatype *myTypeP = &myType;
  _wrap_py_return_val = PMPI_Type_free(myTypeP);

  return _wrap_py_return_val;
}
#endif

/* ================== C Wrappers for MPI_Type_commit ================== */
#ifdef HANDLE_TYPE
int PMPI_Type_commit(MPI_Datatype *datatype);
int MPI_Type_commit(MPI_Datatype *datatype) {
  int _wrap_py_return_val = 0;

  preType(*datatype);
  _wrap_py_return_val = PMPI_Type_commit(datatype);
  postType(datatype);

  return _wrap_py_return_val;
}
#endif

#ifdef HAVE_SESSION
/* ================== C Wrappers for MPI_Session_finalize ================== */
#ifdef HANDLE_SESSION
int PMPI_Session_finalize(MPI_Session *session);
int MPI_Session_finalize(MPI_Session *session) {
  int _wrap_py_return_val = 0;

  MPI_Session mySession = sf.getHandle(*session);
  *session = sf.freeHandle(*session);
  MPI_Session *mySessionP = &mySession;
  _wrap_py_return_val = PMPI_Session_finalize(mySessionP);

  return _wrap_py_return_val;
}
#endif
#endif
}
#endif
