find_program(TYPEART_LCOV_EXEC lcov)
find_program(TYPEART_GENHTML_EXEC genhtml)

if(TYPEART_LCOV_EXEC-NOTFOUND OR TYPEART_GENHTML_EXEC-NOTFOUND)
  message(WARNING "lcov and genhtml command needed for coverage.")
endif()

add_custom_target(
  typeart-lcov-clean
  COMMAND ${TYPEART_LCOV_EXEC} -d ${CMAKE_BINARY_DIR} -z
)

if(CMAKE_CXX_COMPILER_ID MATCHES "Clang")
  typeart_find_llvm_progs(TYPEART_LLVMCOV_EXEC "llvm-cov-${LLVM_VERSION_MAJOR};llvm-cov")
  if(NOT TYPEART_LLVMCOV_EXEC)
    message(FATAL_ERROR "Did not find llvm-cov, which is required for Clang-based LCOV coverage.")
  endif()
  # workaround lcov and clang --coverage have a version mismatch
  set(GCOV_TOOL --gcov-tool ${CMAKE_BINARY_DIR}/scripts/llvm-gcov.sh)
  # these autogenerated file in build/* causes error when using llvm-cov gcov (should be fine with gcc),
  set(GCOV_WORKAROUND --rc derive_function_end_line=0)
  if(${LLVM_VERSION_MAJOR} GREATER_EQUAL 14)
    # LCOV version dependent but suffices for Action CI
    set(GCOV_WORKAROUND --exclude */Version.cpp ${GCOV_WORKAROUND})
  endif()
endif()

add_custom_target(
  typeart-lcov-make
  COMMAND ${TYPEART_LCOV_EXEC} ${GCOV_TOOL} ${GCOV_WORKAROUND}
          --no-external -c -d ${CMAKE_BINARY_DIR} -b ${CMAKE_SOURCE_DIR} -o typeart.coverage
  COMMAND ${TYPEART_LCOV_EXEC} --rc derive_function_end_line=0 --remove typeart.coverage '${CMAKE_BINARY_DIR}/*' -o typeart.coverage
)

add_custom_target(
  typeart-lcov-html
  COMMAND ${TYPEART_GENHTML_EXEC} --rc derive_function_end_line=0 
  -o ${TYPEART_PROFILE_DIR} typeart.coverage
  DEPENDS typeart-lcov-make
)

function(typeart_target_lcov target)
#  add_custom_target(
#    lcov-clean-${target}
#    COMMAND lcov -d ${CMAKE_BINARY_DIR} -z
#    WORKING_DIRECTORY ${PROJECT_BINARY_DIR}
#  )

  get_target_property(LCOV_TARGET_SOURCE_DIR ${target} SOURCE_DIR)

  add_custom_target(
    typeart-lcov-make-${target}
    COMMAND ${TYPEART_LCOV_EXEC} ${GCOV_TOOL} ${GCOV_WORKAROUND}
            --no-external -c -d ${CMAKE_BINARY_DIR}
            -b ${LCOV_TARGET_SOURCE_DIR} -o counter-${target}.pro
    COMMAND ${TYPEART_LCOV_EXEC} --remove counter-${target}.pro '${CMAKE_BINARY_DIR}/*'
            -o counter-${target}.pro
    WORKING_DIRECTORY ${CMAKE_BINARY_DIR}
  )

  add_custom_target(
    typeart-lcov-html-${target}
    COMMAND ${TYPEART_GENHTML_EXEC} -o ${TYPEART_PROFILE_DIR} counter-${target}.pro
    WORKING_DIRECTORY ${CMAKE_BINARY_DIR}
    DEPENDS typeart-lcov-make-${target}
  )
endfunction()
