/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file RMAValueChecks.h
 *       @see MUST::RMAValueChecks.
 *
 *  @date 15.01.2025
 *  @author Cornelius Pätzold
 */

#include "ModuleBase.h"
#include "I_RMAValueChecks.h"
#include "I_ParallelIdAnalysis.h"
#include "I_ArgumentAnalysis.h"
#include "I_CreateMessage.h"
#include "I_BaseConstants.h"

#include <string>

#ifndef RMAVALUECHECKS_H
#define RMAVALUECHECKS_H

using namespace gti;

namespace must
{
/**
 * Implementation for I_RMAValueChecks.
 */
class RMAValueChecks : public gti::ModuleBase<RMAValueChecks, I_RMAValueChecks>
{
  public:
    /**
     * Constructor.
     * @param instanceName name of this module instance.
     */
    RMAValueChecks(const char* instanceName);

    /**
     * Destructor.
     */
    virtual ~RMAValueChecks(void);

    /**
     * @see I_RMAValueChecks::init.
     */
    GTI_ANALYSIS_RETURN init() override;

    /**
     * @see I_RMAValueChecks::errorIfInvalidFenceAssertion.
     */
    GTI_ANALYSIS_RETURN
    errorIfInvalidFenceAssertion(MustParallelId pId, MustLocationId lId, int assert) override;

    /**
     * @see I_RMAValueChecks::errorIfInvalidPostAssertion.
     */
    GTI_ANALYSIS_RETURN
    errorIfInvalidPostAssertion(MustParallelId pId, MustLocationId lId, int assert) override;

    /**
     * @see I_RMAValueChecks::errorIfInvalidStartAssertion.
     */
    GTI_ANALYSIS_RETURN
    errorIfInvalidStartAssertion(MustParallelId pId, MustLocationId lId, int assert) override;

    /**
     * @see I_RMAValueChecks::errorIfInvalidLockAssertion.
     */
    GTI_ANALYSIS_RETURN
    errorIfInvalidLockAssertion(MustParallelId pId, MustLocationId lId, int assert) override;

    /**
     * @see I_RMAValueChecks::errorIfInvalidLockType.
     */
    GTI_ANALYSIS_RETURN
    errorIfInvalidLockType(MustParallelId pId, MustLocationId lId, int lock_type) override;

  private:
    // Helper function that checks if @assert is part of @validAssertions
    GTI_ANALYSIS_RETURN errorIfInvalidAssertion(
        MustParallelId pId,
        MustLocationId lId,
        int assert,
        int validAssertions);

  protected:
    I_ParallelIdAnalysis* myPIdMod;
    I_CreateMessage* myLogger;
    I_ArgumentAnalysis* myArgMod;
    I_BaseConstants* myConstMod;

    int myValidFenceAssertions = 0;
    int myValidPostAssertions = 0;
    int myValidStartAssertions = 0;
    int myValidLockAssertions = 0;
    int myValidLockTypes = 0;
};
} // namespace must

#endif /*RMAVALUECHECKS_H*/
