/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file I_DGroupListener.h
 *       @see I_DGroupListener.
 *
 *  @date 14.04.2025
 *  @author Cornelius Pätzold
 */

#include "I_Module.h"
#include "GtiEnums.h"
#include "BaseIds.h"
#include "I_Win.h"

#ifndef I_DGROUPLISTENER_H
#define I_DGROUPLISTENER_H

namespace must
{
/**
 * Interface for listener on P2P events.
 */
class I_DGroupListener
{
  public:
    /**
     * Notifies the listener of a new Group operation that at DGroupMatch.
     * (Only of ranks that send to this TBON node, not of remote sends)
     *
     * @param pId parallel Id of the call site.
     * @param lId location Id of the call site.
     * @see QOpCommunicationGroupNonBlocking::QOpCommunicationGroupNonBlocking
     * @param outIsActive pointer to storage for bool value, listener sets this to true if
     *               he considers this op as "active" and to false otherwise.
     * @return the logical timestamp that was given to this op.
     */
    virtual MustLTimeStamp newGroupOp(
        MustParallelId pId,
        MustLocationId lId,
        I_CommPersistent* comm,
        I_WinPersistent* win,
        bool isSend,
        int sourceTarget,
        MustSendMode mode) = 0;

    /**
     * Notifies the listener of a match for a Group receive call.
     *
     * @param pIdRecv parallel ID of the receive.
     * @param recvTS logical timestamp of the receive.
     * @param pIdSend parallel ID of the matching send.
     * @param sendTS logical timestamp of the matching send.
     */
    virtual void notifyP2PRecvMatch(
        MustParallelId pIdRecv,
        MustLTimeStamp recvTS,
        MustParallelId pIdSend,
        MustLTimeStamp sendTS) = 0;

    virtual void newGroupCompletionOp(
        MustParallelId pId,
        MustLocationId lId,
        I_CommPersistent* comm,
        MustLTimeStamp* timestamps,
        int count,
        bool hasRequest,
        MustRequestType request) = 0;

}; /*class I_DGroupListener*/
} // namespace must

#endif /*I_DGROUPLISTENER_H*/
