/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file QOpCommunicationGroup.h
 *       @see must::QOpCommunicationGroup.
 *
 *  @date 22.04.2025
 *  @author Cornelius Pätzold
 */

#include "MustEnums.h"
#include "BaseIds.h"
#include "MustTypes.h"
#include "I_WinTrack.h"

#include "QOpCommunicationP2P.h"

#ifndef QOPCOMMUNICATIONGROUP_H
#define QOPCOMMUNICATIONGROUP_H

using namespace gti;

namespace must
{
/**
 * A group communication operation.
 */
class QOpCommunicationGroup : public QOpCommunicationP2P
{
  public:
    /**
     * Constructor for any P2P communication operation.
     * @see QOpCommunication::QOpCommunication
     * @param isSend true if this is a send, receive iff false.
     * @param sourceTarget source or target of receive/send.
     * @param isWc true if this is a wildcard receive (irrespective of whether we got and applied a
     * receive update to the sourceTarget already).
     * @param mode if this is a send, this is the send mode.
     * @param tag of this P2P op.
     */
    QOpCommunicationGroup(
        DWaitState* dws,
        MustParallelId pId,
        MustLocationId lId,
        MustLTimeStamp ts,
        I_CommPersistent* comm,
        I_WinPersistent* win,
        bool isSend,
        int sourceTarget,
        MustSendMode mode);

    virtual std::string getCompletionEdgeLabel();

    virtual std::list<I_Win*> getUsedWins();

  protected:
    I_WinPersistent* myWin;

    virtual std::stringstream getLabels(
        int count,
        std::map<I_Comm*, std::string>& commLabels,
        std::map<I_Win*, std::string>& winLabels);

    /**
     * Destructor.
     */
    virtual ~QOpCommunicationGroup(void);
};

} /*namespace must*/

#endif /*QOPCOMMUNICATIONGROUP_H*/
