/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file QOpCommunicationGroupNonBlocking.cpp
 *       @see must::QOpCommunicationGroupNonBlocking.
 *
 *  @date 22.04.2025
 *  @author Cornelius Pätzold
 */

#include "QOpCommunicationGroupNonBlocking.h"

using namespace must;

//=============================
// QOpCommunicationGroupNonBlocking
//=============================
QOpCommunicationGroupNonBlocking::QOpCommunicationGroupNonBlocking(
    DWaitState* dws,
    MustParallelId pId,
    MustLocationId lId,
    MustLTimeStamp ts,
    I_CommPersistent* comm,
    I_WinPersistent* win,
    bool isSend,
    int sourceTarget,
    MustSendMode mode,
    MustRequestType request)
    : QOp(dws, pId, lId, ts),
      QOpCommunicationGroup(dws, pId, lId, ts, comm, win, isSend, sourceTarget, mode),
      myRequest(request)
{
    // Nothing to do
}

//=============================
// QOpCommunicationGroupNonBlocking
//=============================
QOpCommunicationGroupNonBlocking::~QOpCommunicationGroupNonBlocking(void)
{
    // Nothing to do
}

//=============================
// hasRequest
//=============================
bool QOpCommunicationGroupNonBlocking::hasRequest() { return true; }

//=============================
// getRequest
//=============================
MustRequestType QOpCommunicationGroupNonBlocking::getRequest() { return myRequest; }

//=============================
// printVariablesAsLabelString
//=============================
std::string QOpCommunicationGroupNonBlocking::printVariablesAsLabelString(void)
{
    std::stringstream stream;
    stream << "|request=" << myRequest;

    return QOpCommunicationGroup::printVariablesAsLabelString() + stream.str();
}

//=============================
// isNonBlockingP2P
//=============================
bool QOpCommunicationGroupNonBlocking::isNonBlockingP2P(void) { return true; }

/*EOF*/
