/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file QOpCommunicationGroupNonBlocking.h
 *       @see must::QOpCommunicationGroupNonBlocking.
 *
 *  @date 22.04.2025
 *  @author Cornelius Pätzold
 */

#ifndef QOPCOMMUNICATIONGROUPNONBLOCKING_H
#define QOPCOMMUNICATIONGROUPNONBLOCKING_H

#include "MustEnums.h"
#include "BaseIds.h"
#include "MustTypes.h"

#include "QOpCommunicationGroup.h"

using namespace gti;

namespace must
{
/**
 * A non-blocking group communication operation.
 */
class QOpCommunicationGroupNonBlocking : public QOpCommunicationGroup
{
  public:
    /**
     * Constructor for any group communication operation.
     * @see QOpCommunicationGroup::QOpCommunicationGroup
     * @param request associated with this non-blocking group communication.
     */
    QOpCommunicationGroupNonBlocking(
        DWaitState* dws,
        MustParallelId pId,
        MustLocationId lId,
        MustLTimeStamp ts,
        I_CommPersistent* comm,
        I_WinPersistent* win,
        bool isSend,
        int sourceTarget,
        MustSendMode mode,
        MustRequestType request);

    /**
     * @see QOpCommunication::hasRequest
     * Returns true.
     */
    virtual bool hasRequest(void);

    /**
     * @see QOpCommunication::getRequest
     * Returns the request.
     */
    virtual MustRequestType getRequest(void);

    /**
     * @see QOp::printVariablesAsLabelString
     */
    virtual std::string printVariablesAsLabelString(void);

    /**
     * @see QOpCommunicationP2P
     */
    virtual bool isNonBlockingP2P(void);

  protected:
    MustRequestType myRequest;

    /**
     * Destructor.
     */
    virtual ~QOpCommunicationGroupNonBlocking(void);
};

} /*namespace must*/

#endif /*QOPCOMMUNICATIONGROUPNONBLOCKING_H*/
