/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file QOpGroupCompletion.h
 *       @see must::QOpGroupCompletion.
 *
 *  @date 14.05.2025
 *  @author Cornelius Pätzold
 */

#include "MustEnums.h"
#include "BaseIds.h"
#include "MustTypes.h"
#include "QOpCommunication.h"
#include "QOpCompletion.h"

#include "QOp.h"

#include <vector>

#ifndef QOPGROUPCOMPLETION_H
#define QOPGROUPCOMPLETION_H

using namespace gti;

namespace must
{
/**
 * A completion operation for neighborhood collectives.
 */
class QOpGroupCompletion : public QOpCommunication, public QOpCompletion
{
  public:
    // Constructor for waiting on multiple timestamps of groupOps
    QOpGroupCompletion(
        DWaitState* dws,
        MustParallelId pId,
        MustLocationId lId,
        MustLTimeStamp ts,
        int count,
        MustLTimeStamp* timestamps,
        I_CommPersistent* comm);

    /**
     * @see QOp::printAsDot
     */
    virtual std::string printAsDot(std::ofstream& out, std::string nodePrefix, std::string color);

    /**
     * @see QOp::printVariablesAsLabelString
     */
    virtual std::string printVariablesAsLabelString(void);

    /**
     * @see QOp::notifyActive
     */
    virtual void notifyActive(void);

    /**
     * @see QOp::notifyActive
     */
    virtual bool blocks(void);

    bool isMatchedWithActiveOps(void);

    /**
     * @see QOp::needsToBeInTrace
     */
    virtual bool needsToBeInTrace(void);

    /**
     * @see QOp::forwardWaitForInformation
     */
    virtual void forwardWaitForInformation(
        std::map<I_Comm*, std::string>& commLabels,
        std::map<I_Win*, std::string>& winLabels);

    virtual void forwardThisOpsWaitForInformation(
        int subIdToUse,
        std::map<I_Comm*, std::string>& commLabels,
        std::map<I_Win*, std::string>& winLabels);

    /**
     * @see QOp::getUsedComms
     */
    virtual std::list<I_Comm*> getUsedComms(void);

    /**
     * @see QOp::getUsedWins
     */
    virtual std::list<I_Win*> getUsedWins(void);

    /**
     * @see QOp::asOpGroupCompletion
     */
    QOpGroupCompletion* asOpGroupCompletion(void);

    /**
     * @see QOp::getPingPongNodes
     */
    virtual std::set<int> getPingPongNodes(void);

  protected:
    RequestInfo myRequest;
    std::vector<RequestInfo> myRequests;

    bool myWaitsForAll;
    unsigned myNumCompleted;
    int myMatchIndex; /**< Index of first completed request.*/

    /**
     * Destructor.
     */
    virtual ~QOpGroupCompletion(void);
};

} /*namespace must*/

#endif /*QOPGROUPCOMPLETION_H*/
