/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file QOpGroupCompletionNonBlocking.cpp
 *       @see must::QOpGroupCompletionNonBlocking.
 *
 *  @date 14.04.2025
 *  @author Corneius Pätzold
 */

#include "QOpGroupCompletionNonBlocking.h"

using namespace must;

//=============================
// QOpGroupCompletionNonBlocking -- Constructor
//=============================
QOpGroupCompletionNonBlocking::QOpGroupCompletionNonBlocking(
    DWaitState* dws,
    MustParallelId pId,
    MustLocationId lId,
    MustLTimeStamp ts,
    int count,
    MustLTimeStamp* timestamps,
    I_CommPersistent* comm,
    MustRequestType request)
    : QOp(dws, pId, lId, ts), QOpGroupCompletion(dws, pId, lId, ts, count, timestamps, comm),
      myRequest(request)
{
}

//=============================
// QOpGroupCompletionNonBlocking -- Destructor
//=============================
QOpGroupCompletionNonBlocking::~QOpGroupCompletionNonBlocking(void)
{
    // Nothing to do
}

//=============================
// hasRequest
//=============================
bool QOpGroupCompletionNonBlocking::hasRequest() { return true; }

//=============================
// getRequest
//=============================
MustRequestType QOpGroupCompletionNonBlocking::getRequest() { return myRequest; }

//=============================
// printVariablesAsLabelString
//=============================
std::string QOpGroupCompletionNonBlocking::printVariablesAsLabelString(void)
{
    std::stringstream stream;
    stream << "|request=" << myRequest;

    return QOpGroupCompletion::printVariablesAsLabelString() + stream.str();
}

/*EOF*/
