/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file QOpGroupCompletionNonBlocking.h
 *       @see must::QOpGroupCompletionNonBlocking.
 *
 *  @date 14.05.2025
 *  @author Cornelius Pätzold
 */

#include "MustEnums.h"
#include "BaseIds.h"
#include "MustTypes.h"

#include "QOpGroupCompletion.h"

#ifndef QOPGROUPCOMPLETIONNONBLOCKING_H
#define QOPGROUPCOMPLETIONNONBLOCKING_H

using namespace gti;

namespace must
{
/**
 * A completion operation for neighborhood collectives.
 */
class QOpGroupCompletionNonBlocking : public QOpGroupCompletion
{
  public:
    // Constructor for waiting on multiple timestamps of nonblocking groupOps
    QOpGroupCompletionNonBlocking(
        DWaitState* dws,
        MustParallelId pId,
        MustLocationId lId,
        MustLTimeStamp ts,
        int count,
        MustLTimeStamp* timestamps,
        I_CommPersistent* comm,
        MustRequestType request);

    /**
     * @see QOpCommunication::hasRequest
     * Returns true.
     */
    virtual bool hasRequest(void);

    /**
     * @see QOpCommunication::getRequest
     * Returns the request.
     */
    virtual MustRequestType getRequest(void);

    /**
     * @see QOp::printVariablesAsLabelString
     */
    virtual std::string printVariablesAsLabelString(void);

  protected:
    MustRequestType myRequest;
    /**
     * Destructor.
     */
    virtual ~QOpGroupCompletionNonBlocking(void);
};

} /*namespace must*/

#endif /*QOPGROUPCOMPLETIONNONBLOCKING_H*/
