/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file FileChecks.h
 *       @see MUST::FileChecks.
 */

#include "ModuleBase.h"
#include "I_ParallelIdAnalysis.h"
#include "I_ArgumentAnalysis.h"
#include "I_CreateMessage.h"
#include "I_FileChecks.h"
#include "I_BaseConstants.h"

#include <string>

#ifndef FileCHECKS_H
#define FileCHECKS_H

using namespace gti;

namespace must
{
/**
 * FileChecks for correctness checks of communicators, interface implementation.
 */
class FileChecks : public gti::ModuleBase<FileChecks, I_FileChecks>
{

  private:
    I_ParallelIdAnalysis* myPIdMod;
    I_CreateMessage* myLogger;
    I_ArgumentAnalysis* myArgMod;
    I_FileTrack* myFileMod;

  public:
    /**
     * Constructor.
     * @param instanceName name of this module instance.
     */
    FileChecks(const char* instanceName);
    ~FileChecks(void);

    GTI_ANALYSIS_RETURN
    errorIfNull(MustParallelId pId, MustLocationId lId, int aId, MustFileType file);

    GTI_ANALYSIS_RETURN
    errorIfNotKnown(MustParallelId pId, MustLocationId lId, int aId, MustFileType file);

    GTI_ANALYSIS_RETURN
    errorIfOpenRequest(MustParallelId pId, MustLocationId lId, MustFileType file);
};

} // namespace must

#endif /*FILECHECKS_H*/
