/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file I_FileChecks.h
 *       @see I_FileChecks.
 */

#include "I_Module.h"
#include "GtiEnums.h"
#include "BaseIds.h"
#include "I_FileTrack.h"

#ifndef I_FileCHECKS_H
#define I_FileCHECKS_H

/**
 * Interface for correctness checks of files.
 *
 */
class I_FileChecks : public gti::I_Module
{
  public:
    virtual gti::GTI_ANALYSIS_RETURN
    errorIfNull(MustParallelId pId, MustLocationId lId, int aId, MustFileType file) = 0;

    virtual gti::GTI_ANALYSIS_RETURN
    errorIfNotKnown(MustParallelId pId, MustLocationId lId, int aId, MustFileType file) = 0;

    virtual gti::GTI_ANALYSIS_RETURN
    errorIfOpenRequest(MustParallelId pId, MustLocationId lId, MustFileType file) = 0;

}; /*class I_FileChecks*/

#endif /*I_FileCHECKS_H*/
