/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file InfoChecks.h
 *       @see MUST::InfoChecks.
 *
 *  @date 14.04.2011
 *  @author Mathias Korepkat
 */

#include "ModuleBase.h"
#include "I_ParallelIdAnalysis.h"
#include "I_ArgumentAnalysis.h"
#include "I_CreateMessage.h"
#include "I_InfoChecks.h"
#include "I_BaseConstants.h"

#include <string>

#ifndef INFOCHECKS_H
#define INFOCHECKS_H

using namespace gti;

namespace must
{
/**
 * InfoChecks for correctness checks of communicators, interface implementation.
 */
class InfoChecks : public gti::ModuleBase<InfoChecks, I_InfoChecks>
{
  public:
    /**
     * Constructor.
     * @param instanceName name of this module instance.
     */
    InfoChecks(const char* instanceName);

    /**
     * Destructor.
     */
    virtual ~InfoChecks(void);

    /**
     * @see I_InfoChecks::errorIfLengthNotWithinRangeZeroAndLessMaxInfoKey.
     */
    GTI_ANALYSIS_RETURN errorIfLengthNotWithinRangeZeroAndLessMaxInfoKey(
        MustParallelId pId,
        MustLocationId lId,
        int aId,
        char* key);

    /**
     * @see I_InfoChecks::errorIfLengthNotWithinRangeZeroAndLessMaxInfoVal.
     */
    GTI_ANALYSIS_RETURN errorIfLengthNotWithinRangeZeroAndLessMaxInfoVal(
        MustParallelId pId,
        MustLocationId lId,
        int aId,
        char* value);

    /**
     * @see I_InfoChecks::errorIfNull.
     */
    GTI_ANALYSIS_RETURN
    errorIfNull(MustParallelId pId, MustLocationId lId, int aId, MustInfoType infoHandle);

    /**
     * @see I_InfoChecks::errorIfNotKnown.
     */
    GTI_ANALYSIS_RETURN
    errorIfNotKnown(MustParallelId pId, MustLocationId lId, int aId, MustInfoType infoHandle);

    /**
     * @see I_InfoChecks::errorIfKeyNotDefined.
     */
    GTI_ANALYSIS_RETURN errorIfKeyNotDefined(
        MustParallelId pId,
        MustLocationId lId,
        int aId,
        char* key,
        MustInfoType infoHandle);

    GTI_ANALYSIS_RETURN warningIfKeyNotDefined(
        MustParallelId pId,
        MustLocationId lId,
        int aId,
        char* key,
        MustInfoType infoHandle);

    GTI_ANALYSIS_RETURN errorIfNthKeyNotDefined(
        MustParallelId pId,
        MustLocationId lId,
        int aId,
        int n,
        MustInfoType infoHandle);

    GTI_ANALYSIS_RETURN warningIfNthKeyNotDefined(
        MustParallelId pId,
        MustLocationId lId,
        int aId,
        int n,
        MustInfoType infoHandle);

  protected:
    I_ParallelIdAnalysis* myPIdMod;
    I_CreateMessage* myLogger;
    I_ArgumentAnalysis* myArgMod;
    I_InfoTrack* myInfoMod;
    I_BaseConstants* myConstMod;
};
} // namespace must

#endif /*INFOCHECKS_H*/
