/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file I_TargetRaceVerifier.h
 *       @see I_TargetRaceVerifier
 *
 *  @date 02.05.2025
 *  @author Simon Schwitanski
 */

#include "GtiEnums.h"

#include "MustEnums.h"
#include "BaseIds.h"
#include "MustTypes.h"
#include "Clock.h"

#ifndef I_TARGETRACEVERIFIER_H
#define I_TARGETRACEVERIFIER_H

struct RMAOpHistoryData {
    MustRMAId callId;
    bool isAtomic;
    int epoch;
    RMADataTypeId type;
    size_t typeSize;
    MustAddressType startAddr;
    MustLocationId lIdStart;
    MustLocationId lIdEnd;
    Clock startClock;
    Clock endClock;
};

/**
 * RMA race verifier for a detected TSan race.
 *
 * Dependencies (in listed order):
 * - ParallelIdAnalysis
 * - ArgumentAnalysis
 * - DatatypeTrack
 * - RequestTrack
 * - WinTrack
 */
class I_TargetRaceVerifier : public gti::I_Module
{
  public:
    virtual bool
    isRace(MustParallelId pId1, MustRMAId rmaId1, MustParallelId pId2, MustRMAId rmaId2) = 0;

    virtual void addHistoryData(
        int origin,
        MustRMAId rmaId,
        bool isAtomic,
        int epoch,
        RMADataTypeId type,
        size_t typeSize,
        MustAddressType startAddr,
        MustLocationId lIdStart,
        MustLocationId lIdEnd,
        Clock startClock,
        Clock endClock) = 0;

    virtual bool getHistoryData(MustParallelId pId, MustRMAId rmaId, RMAOpHistoryData& op) = 0;

}; /*class I_TargetRaceVerifier*/

#endif /*I_TARGETRACEVERIFIER_H*/
