/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file I_File.h
 *       @see I_File.
 */

#include "I_File.h"
#include "HandleInfoBase.h"

#ifndef File_H
#define File_H

namespace must
{
/**
 * Implementation of I_File.
 */
class File : public I_FilePersistent, public HandleInfoBase
{
  public:
    /**
     * Constructor.
     * Initializes as a MPI_File info.
     */
    File();

    /**
     * Constructor.
     * Initializes as a valid file.
     */
    File(int* pReachableBegin, int* pReachableEnd);

    /**
     * Destructor.
     */
    ~File();

    bool isNull(void);                     /**< @see I_File::isNull.*/
    unsigned long long getContextId(void); /**< @see I_File::contextId.*/
    I_CommPersistent* getComm(void);       /**< @see I_File::getComm.*/
    MustCommType getCommHandle(void);      /**< @see I_File::getCommHandle.*/
    MustParallelId getCreationPId(void);   /**< @see I_File::creationPId.*/
    MustLocationId getCreationLId(void);   /**< @see I_File::creationLId.*/
    void setTypeIdEtype(MustDatatypeType typeIdEtype);
    void setTypeIdFiletype(MustDatatypeType typeIdFiletype);
    void setInitialDisplacement(size_t initialDisplacement);
    MustDatatypeType getTypeIdEtype(void);
    MustDatatypeType getTypeIdFiletype(void);
    size_t getInitialDiscplacement(void);
    bool getReorder(void);            /**< @see I_File::reorder.*/
    bool compareFiles(I_File* other); /**< @see I_File::compareFiles.*/
    bool operator==(I_File& other);   /**< @see I_File::operator==.*/
    bool operator!=(I_File& other);   /**< @see I_File::operator!=.*/
    bool printInfo(
        std::stringstream& out,
        std::list<std::pair<MustParallelId, MustLocationId>>*
            pReferences); /**< @see I_Comm::printInfo.*/

    std::string getResourceName(void); /**< @see HandleInfoBase::getResourceName.*/
    std::unordered_map<MustRequestType, MustLocationId>& getOpenRequests(void)
    {
        return myOpenRequests;
    }

  public:
    bool myIsNull;

    std::string myPredefinedName;
    I_CommPersistent* myComm;
    MustCommType myCommHandle;

    MustDatatypeType typeIdEtype;
    MustDatatypeType typeIdFiletype;
    size_t initialDisplacement;
    unsigned long long myContextId;

    // Only for user defined comms
    MustParallelId myCreationPId;
    MustLocationId myCreationLId;

    // Information on processes reachable on this node
    int* myPReachableBegin; /**< Pointer to storage for beginning MPI_COMM_WORLD rank of reachable
                               processes.*/
    int* myPReachableEnd;   /**< Pointer to storage for last MPI_COMM_WORLD rank of reachable
                               processes.*/

    std::unordered_map<MustRequestType, MustLocationId> myOpenRequests{};

}; /*class File*/
} /*namespace must*/

#endif /*FILE_H*/
