/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file FileTrack.h
 *       @see MUST::FileTrack
 */

#include "ModuleBase.h"
#include "TrackBase.h"
#include "CompletionTree.h"

#include "I_RequestTrack.h"
#include "I_FileTrack.h"
#include "File.h"

#include <map>

#ifndef FILETRACK_H
#define FILETRACK_H

using namespace gti;

namespace must
{
enum MustMpiFilePredefined { MUST_MPI_FILE_UNKNOWN = 0 };
/**
 * Implementation for I_FileTrack.
 */
class FileTrack
    : public TrackBase<File, I_File, MustFileType, MustMpiFilePredefined, FileTrack, I_FileTrack>
{
  public:
    /**
     * Constructor.
     * @param instanceName name of this module instance.
     */
    FileTrack(const char* instanceName);

    /**
     * Destructor.
     */
    virtual ~FileTrack(void);

    /**
     * @see I_FileTrack::fileOpen.
     */
    GTI_ANALYSIS_RETURN
    fileOpen(MustParallelId pId, MustLocationId lId, MustCommType comm, int amode, MustFileType fh);

    /**
     * @see I_FileTrack::fileClose.
     */
    GTI_ANALYSIS_RETURN fileClose(MustParallelId pId, MustLocationId lId, MustFileType fh);

    /**
     * @see I_FileTrack::fileSetView.
     */
    GTI_ANALYSIS_RETURN fileSetView(
        MustParallelId pId,
        MustLocationId lId,
        MustFileType fh,
        int64_t displacement,
        MustDatatypeType etype,
        MustDatatypeType filetype);

    /**
     * @see I_FileTrack::getFile
     */
    I_File* getFile(MustParallelId pId, MustFileType file);

    /**
     * @see  I_FileTrack::getFile
     */
    I_File* getFile(int rank, MustFileType file);

    File* getFileInfo(MustParallelId pId, MustFileType file);

    /**
     * @see other getFileInfo, difference is pid.
     */
    File* getFileInfo(int rank, MustFileType file);

    /**
     * @see I_FileTrack::getPersistentFile
     */
    I_FilePersistent* getPersistentFile(MustParallelId pId, MustFileType file);

    /**
     * @see I_FileTrack::getPersistentFile
     */
    I_FilePersistent* getPersistentFile(int rank, MustFileType file);

    GTI_ANALYSIS_RETURN
    addRequest(MustParallelId pId, MustLocationId lId, MustFileType file, MustRequestType request);

    GTI_ANALYSIS_RETURN
    removeRequest(
        MustParallelId pId,
        MustLocationId lId,
        MustFileType file,
        MustRequestType request);

  protected:
    I_CommTrack* myCTrack;
    I_DatatypeTrack* myDTrack;
    I_RequestTrack* myRTrack;

    /**
     * Implementation of TrackBase::createPredefinedInfo.
     */
    File* createPredefinedInfo(int value, MustRequestType handle);

}; /*class FileTrack */
} // namespace must

#endif /*FILETRACK_H*/
