/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file Info.h
 *       @see Info.
 *
 *  @date 19.07.2011
 *  @author Tobias Hilbrich, Joachim Protze, Mathias Korepkat
 */

#include "Info.h"

#include <sstream>
#include <unordered_map>

using namespace must;

//=============================
// Constructor
//=============================
Info::Info()
    : HandleInfoBase("Info"), myPredefined(MUST_MPI_INFO_ENV), myKeyValPairs({}), myIsNull(true),
      myIsPredefined(false), myCreationPId(0), myCreationLId(0)
{
    // Nothing to do
}

//=============================
// Info
//=============================
Info::Info(MustMpiInfoPredefined predefined, std::string predefinedName)
    : HandleInfoBase("Info"), myPredefined(predefined), myPredefinedName(predefinedName),
      myKeyValPairs({}), myIsNull(false), myIsPredefined(true), myCreationPId(0), myCreationLId(0)
{
    // Nothing to do
}

//=============================
// Info
//=============================
// TODO: support for MPI_Info_create_env could include the argc/argv information
// Info::Info(MustMpiInfoPredefined predefined, std::string predefinedName, int argc, char* argv[])
//     : HandleInfoBase("Info"), myPredefined(predefined), myPredefinedName(predefinedName),
//     myKeyValPairs({}),
//       myIsNull(false), myIsPredefined(true), myCreationPId(0), myCreationLId(0)
// {
//     if (argc > 0){
//         myKeyValPairs.insert({"command",argv[0]});
//     }

// }

//=============================
// ~Info
//=============================
Info::~Info()
{
    // Nothing to do
}

//=============================
// isNull
//=============================
bool Info::isNull(void) { return myIsNull; }

//=============================
// isPredefined
//=============================
bool Info::isPredefined(void) { return myIsPredefined; }

//=============================
// getCreationPId
//=============================
MustParallelId Info::getCreationPId(void) { return myCreationPId; }

//=============================
// getCreationLId
//=============================
MustLocationId Info::getCreationLId(void) { return myCreationLId; }

//=============================
// getPredefinedInfo
//=============================
MustMpiInfoPredefined Info::getPredefinedInfo(void) { return myPredefined; }

//=============================
// getPredefinedName
//=============================
std::string Info::getPredefinedName(void) { return myPredefinedName; }

//=============================
// getKeyValPairs
//=============================
std::unordered_map<std::string, std::string>& Info::getKeyValPairs(void) { return myKeyValPairs; }

//=============================
// printInfo
//=============================
bool Info::printInfo(
    std::stringstream& out,
    std::list<std::pair<MustParallelId, MustLocationId>>* pReferences)
{
    // Is Null
    if (myIsNull) {
        out << "MPI_INFO_NULL";
        return true;
    }

    // Is Predefined
    if (myIsPredefined) {
        out << myPredefinedName;
        return true;
    }

    // A user defined info
    pReferences->push_back(std::make_pair(myCreationPId, myCreationLId));
    out << "Info created at reference  " << pReferences->size();

    return true;
}

//=============================
// getResourceName
//=============================
std::string Info::getResourceName(void) { return "Info"; }

/*EOF*/
