/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file I_Info.h
 *       @see I_Info.
 *
 *  @date 15.07.2011
 *  @author Tobias Hilbrich, Joachim Protze, Mathias Korepkat
 */

#include "I_Info.h"
#include "HandleInfoBase.h"

#include <string>
#include <unordered_map>

#ifndef INFO_H
#define INFO_H

namespace must
{
/**
 * Implementation of I_Comm (and I_CommPersistent).
 */
class Info : public I_InfoPersistent, public HandleInfoBase
{
  public:
    /**
     * Constructor.
     * Initializes as a MPI_INFO_NULL info.
     */
    Info();

    /**
     * Constructor.
     * Initializes as a predefined info.
     */
    Info(MustMpiInfoPredefined predefined, std::string predefinedName);

    /**
     * Destructor.
     */
    ~Info();

    bool isNull(void);                                                  /**< @see I_Info::.*/
    bool isPredefined(void);                                            /**< @see I_Info::.*/
    MustParallelId getCreationPId(void);                                /**< @see I_Info::.*/
    MustLocationId getCreationLId(void);                                /**< @see I_Info::.*/
    MustMpiInfoPredefined getPredefinedInfo(void);                      /**< @see I_Info::.*/
    std::string getPredefinedName(void);                                /**< @see I_Info::.*/
    std::unordered_map<std::string, std::string>& getKeyValPairs(void); /**< @see I_Info::.*/
    bool printInfo(
        std::stringstream& out,
        std::list<std::pair<MustParallelId, MustLocationId>>* pReferences); /**< @see I_Info::.*/

    std::string getResourceName(void); /**< @see HandleInfoBase::getResourceName.*/

  public:
    MustMpiInfoPredefined myPredefined;
    std::string myPredefinedName;

    bool myIsNull;
    bool myIsPredefined;
    std::unordered_map<std::string, std::string> myKeyValPairs;
    MustParallelId myCreationPId;
    MustLocationId myCreationLId;

}; /*class Info*/
} /*namespace must*/

#endif /*INFO_H*/
