/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file InfoTrack.h
 *       @see MUST::InfoTrack
 *
 *  @date 12.05.2011
 *  @author Tobias Hilbrich
 */

#include "ModuleBase.h"
#include "TrackBase.h"

#include "I_InfoTrack.h"
#include "Info.h"

#include <map>

#ifndef INFOTRACK_H
#define INFOTRACK_H

using namespace gti;

namespace must
{
/**
 * Implementation of I_InfoTrack.
 */
class InfoTrack
    : public TrackBase<Info, I_Info, MustInfoType, MustMpiInfoPredefined, InfoTrack, I_InfoTrack>
{
  protected:
  public:
    /**
     * Constructor.
     * @param instanceName name of this module instance.
     */
    InfoTrack(const char* instanceName);

    /**
     * Destructor.
     */
    virtual ~InfoTrack(void);

    /**
     * @see I_InfoTrack::infoCreate
     */
    GTI_ANALYSIS_RETURN
    infoCreate(
        MustParallelId pId,
        MustLocationId lId,
        MustInfoType newInfoHandle,
        int keyValuesLen,
        char* keyValues);

    /**
     * @see I_InfoTrack::infoSet
     */
    GTI_ANALYSIS_RETURN
    infoSet(
        MustParallelId pId,
        MustLocationId lId,
        MustInfoType infoHandle,
        const char* key,
        const char* value);

    /**
     * @see I_InfoTrack::infoFree
     */
    GTI_ANALYSIS_RETURN infoFree(MustParallelId pId, MustLocationId lId, MustInfoType infoHandle);

    /**
     * @see I_InfoTrack::getInfo
     */
    I_Info* getInfo(MustParallelId pId, MustInfoType infoHandle);

    /**
     * @see I_InfoTrack::getInfo
     */
    I_Info* getInfo(int rank, MustInfoType infoHandle);

    /**
     * @see I_InfoTrack::getPersistentInfo
     */
    I_InfoPersistent* getPersistentInfo(MustParallelId pId, MustInfoType infoHandle);

    /**
     * @see I_InfoTrack::getPersistentInfo
     */
    I_InfoPersistent* getPersistentInfo(int rank, MustInfoType infoHandle);

  protected:
    /**
     * Used to initialize null and predefined infos.
     * @see TrackBase::createPredefinedInfo.
     * (Implementation of hook)
     */
    Info* createPredefinedInfo(int predef, MustInfoType handle);

    /**
     * Returns a string for a predefined info.
     */
    std::string getPredefinedName(MustMpiInfoPredefined predefined);

}; /*class InfoTrack */
} // namespace must

#endif /*INFOTRACK_H*/
