/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file WinEpoch.cpp
 *       @see WinEpoch.
 */

#include "WinEpoch.h"

using namespace must;

//=============================
// WinEpoch
//=============================
WinEpoch::WinEpoch()
    : mySync(MUST_WIN_EPOCH_NONE), myEpochStartLIds(), mylastRMALId(MUST_INVALID_LOCATION_ID),
      myAssertion(0)
{
    // Nothing to do
}

//=============================
// ~WinEpoch
//=============================
WinEpoch::~WinEpoch()
{
    // Nothing to do
}

//=============================
// getSync
//=============================
unsigned int WinEpoch::getSync(void) const { return mySync; }

//=============================
// getEpochLId
//=============================
MustLocationId WinEpoch::getEpochLId(int rank) const
{
    auto it = myEpochStartLIds.find(rank);
    if (it != myEpochStartLIds.end())
        return it->second;

    return MUST_INVALID_LOCATION_ID;
}

//=============================
// getEpochLIdMap
//=============================
std::map<int, MustLocationId>& WinEpoch::getEpochLIdMap(void) { return myEpochStartLIds; };

//=============================
// getWinStartRanks
//=============================
std::unordered_set<int>& WinEpoch::getWinStartRanks(void) { return myWinStartRanks; };

//=============================
// getLastRMALId
//=============================
MustLocationId WinEpoch::getLastRMALId(void) const { return mylastRMALId; }

//=============================
// getAssertion
//=============================
int WinEpoch::getAssertion(void) const { return myAssertion; }

//=============================
// getEpochLIdKey
//=============================
int WinEpoch::getEpochLIdKey(MUST_WIN_EPOCH_SYNC sync, int rank) const
{
    if (sync == MUST_WIN_EPOCH_NONE || sync & MUST_WIN_EPOCH_LOCK)
        return rank;

    if (sync & (MUST_WIN_EPOCH_POTENTIAL_FENCE | MUST_WIN_EPOCH_FENCE))
        return -MUST_WIN_EPOCH_FENCE;

    return -sync;
};

/*EOF*/
