/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file WinEpoch.h
 *       @see WinEpoch.
 */

#include "I_WinEpoch.h"
#include "MustDefines.h"

#ifndef WINEPOCH_H
#define WINEPOCH_H

namespace must
{
/**
 * Implementation of I_Win (and I_WinPersistent).
 */
class WinEpoch : public I_WinEpoch
{
  public:
    /**
     * Constructor.
     * Initializes the epoch with MPI_WINEPOCH_NONE.
     */
    WinEpoch();

    /**
     * Destructor.
     */
    ~WinEpoch();

    unsigned int getSync(void) const override;
    MustLocationId getEpochLId(int rank) const override;
    MustLocationId getLastRMALId(void) const override;
    int getAssertion(void) const override;
    std::map<int, MustLocationId>& getEpochLIdMap(void) override;
    std::unordered_set<int>& getWinStartRanks(void) override;
    int getEpochLIdKey(MUST_WIN_EPOCH_SYNC sync, int rank) const override;

  public:
    unsigned int mySync : 6;
    // Negative keys are used for MPI_Win_fence, MPI_Win_lock_all, MPI_Win_start, MPI_Win_post
    // Positive keys are the ranks of MPI_Win_lock which are relative to the window
    // communicator
    std::map<int, MustLocationId> myEpochStartLIds;
    // Stores which ranks are part of MPI_Win_start. Ranks are relative to the window communicator
    std::unordered_set<int> myWinStartRanks;
    MustLocationId mylastRMALId;
    int myAssertion;

}; /*class WinEpoch*/
} /*namespace must*/

#endif /*WINEPOCH_H*/
