/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// UNSUPPORTED: fast-tests
// TODO: expected to fail because of missing error handler for MPI_Win
// RUN: %compile-cxx
// RUN: %must-run %mpiexec-numproc-flag 2 %t.exe \
// RUN: 2>&1 \
// RUN: | %filecheck-may-segfault %s

// CHECK: [MUST-REPORT]{{.*Error.*target_disp.*is negative}}

/**
 * @file AddressTypeNegativeError.cpp
 * This is a test for the analysis group BasicChecks.
 *
 * Description:
 * Performs a Get where the Get uses a target_disp of -1, which is a
 * usage error.
 *
 *  @date 01.03.2011
 *  @author Mathias Korepkat
 */

#include <mpi.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>

#define N 10

int main(int argc, char* argv[])
{
    int rank, numProcs;

    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &numProcs);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    int* buffer = (int*)malloc(N * sizeof(int));

    MPI_Win win;
    MPI_Win_create(&buffer, N * sizeof(int), 1, MPI_INFO_NULL, MPI_COMM_WORLD, &win);

    if (rank == 0) {
        MPI_Win_fence(0, win);
        int local_buf[N] = {0};
        MPI_Get(&local_buf, N, MPI_INT, 1, -1, N, MPI_INT, win);

        MPI_Win_fence(0, win);
    } else {
        MPI_Win_fence(0, win);
        MPI_Win_fence(0, win);
    }

    MPI_Win_free(&win);

    free(buffer);

    MPI_Finalize();

    return 0;
}
