/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: %compile-cxx
// RUN: %must-run %mpiexec-numproc-flag 2 %t.exe \
// RUN: 2>&1 \
// RUN: | %filecheck --implicit-check-not \
// RUN: '[MUST-REPORT]{{.*(Error|ERROR|Warning|WARNING)}}' %s

/**
 * @file AssertFenceNoError.cpp
 * This is a test for the analysis group BasicChecks.
 *
 * Description:
 * Provides all valid assertions to MPI_Win_fence
 *
 *  @date 15.01.2025
 *  @author Cornelius Pätzold
 */

#include <iostream>
#include <mpi.h>

int main(int argc, char** argv)
{
    int size, rank;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    MPI_Win win;
    MPI_Win_create(nullptr, 0, 1, MPI_INFO_NULL, MPI_COMM_WORLD, &win);
    MPI_Win_fence(0, win);
    MPI_Win_fence(MPI_MODE_NOPRECEDE, win);
    MPI_Win_fence(MPI_MODE_NOPUT, win);
    MPI_Win_fence(MPI_MODE_NOSTORE, win);
    MPI_Win_fence(MPI_MODE_NOSUCCEED, win);
    int valid_assertions =
        MPI_MODE_NOPRECEDE | MPI_MODE_NOPUT | MPI_MODE_NOSTORE | MPI_MODE_NOSUCCEED;
    // Fence with all valid assertions
    MPI_Win_fence(valid_assertions, win);
    MPI_Win_free(&win);

    MPI_Finalize();

    return 0;
}
