/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: %compile-cxx
// RUN: %must-run %mpiexec-numproc-flag 2 %t.exe \
// RUN: 2>&1 \
// RUN: | %filecheck %s

// CHECK: [MUST-REPORT]{{.*Error: from: call MPI_Win_start@.* The provided assertion (.*) is invalid.}}

/**
 * @file AssertStartError.cpp
 * This is a test for the analysis group BasicChecks.
 *
 * Description:
 * Provides an invalid assertion to MPI_Win_start
 *
 *  @date 15.01.2025
 *  @author Cornelius Pätzold
 */

#include <iostream>
#include <mpi.h>

int main(int argc, char** argv)
{
    int size, rank;
    MPI_Group world_group;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);
    MPI_Comm_group(MPI_COMM_WORLD, &world_group);

    MPI_Win win;
    MPI_Win_create(nullptr, 0, 1, MPI_INFO_NULL, MPI_COMM_WORLD, &win);
    int valid_assertions = MPI_MODE_NOCHECK;
    // Start with invalid assertion (inverse of all valid assertions)
    MPI_Win_post(world_group, 0, win);
    MPI_Win_start(world_group, ~valid_assertions, win);
    MPI_Win_complete(win);
    MPI_Win_wait(win);
    MPI_Win_free(&win);
    MPI_Group_free(&world_group);

    MPI_Finalize();

    return 0;
}
