/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: %compile-cxx
// RUN: %must-run %mpiexec-numproc-flag 2 %t.exe \
// RUN: 2>&1 \
// RUN: | %filecheck --implicit-check-not \
// RUN: '[MUST-REPORT]{{.*(Error|ERROR|Warning|WARNING)}}' %s

/**
 * @file LockTypeNoError.cpp
 * This is a test for the analysis group BasicChecks.
 *
 * Description:
 * Provides all valid lock types to MPI_Win_lock
 *
 *  @date 15.01.2025
 *  @author Cornelius Pätzold
 */

#include <iostream>
#include <mpi.h>

int main(int argc, char** argv)
{
    int size, rank;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    MPI_Win win;
    MPI_Win_create(nullptr, 0, 1, MPI_INFO_NULL, MPI_COMM_WORLD, &win);
    MPI_Win_lock(MPI_LOCK_EXCLUSIVE, 0, 0, win);
    MPI_Win_unlock(0, win);
    MPI_Win_lock(MPI_LOCK_SHARED, 0, 0, win);
    MPI_Win_unlock(0, win);
    MPI_Win_free(&win);

    MPI_Finalize();

    return 0;
}
