/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// UNSUPPORTED: fast-tests
// RUN: %compile-cxx
// RUN: %must-run-ddl %mpiexec-numproc-flag 2 %t.exe \
// RUN: 2>&1 \
// RUN: | %filecheck-may-segfault %s

// CHECK: [MUST-REPORT]{{.*Error:.*Argument.*[(]comm[)].*is a communicator with no topology}}

#include <mpi.h>

#include <vector>

int main(int argc, char** argv)
{
    MPI_Init(&argc, &argv);

    int world_rank, world_size;
    MPI_Comm_rank(MPI_COMM_WORLD, &world_rank);
    MPI_Comm_size(MPI_COMM_WORLD, &world_size);

    int dims[2] = {0, 0};
    MPI_Dims_create(world_size, 2, dims);
    int periods[2] = {1, 1}; // Make cart comm periodic in both dimensions
    MPI_Comm cart_comm;
    MPI_Cart_create(MPI_COMM_WORLD, 2, dims, periods, 1, &cart_comm);

    int cart_rank;
    MPI_Comm_rank(cart_comm, &cart_rank);

    std::vector<int> sendbuf = {cart_rank, cart_rank, cart_rank, cart_rank};
    std::vector<int> recvbuf(world_size, -1);

    // Wrong communicator used
    MPI_Neighbor_allgather(sendbuf.data(), 1, MPI_INT, recvbuf.data(), 1, MPI_INT, MPI_COMM_WORLD);

    MPI_Comm_free(&cart_comm);
    MPI_Finalize();
    return 0;
}
