/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// RUN: %compile-cxx
// UNSUPPORTED: fast-tests
// RUN: %must-run %mpiexec-numproc-flag 2 %t.exe \
// RUN: 2>&1 \
// RUN: | %filecheck-may-segfault %s

// CHECK: [MUST-REPORT]{{.*Error:.*Argument.*[(]intercomm[)].*intracommunicator and was used where an intercommunicator was expected}}

/**
 * @file IsNoIntercommError.cpp
 * This is a a test for the analysis group CommChecks.
 *
 * Description:
 * Performs a intercomm_merge on MPI_COMM_WORLD what will cause an error.
 *
 *  @date 23.05.2011
 *  @author Mathias Korepkat
 */

#include <iostream>
#include <mpi.h>

int main(int argc, char** argv)
{
    int size, rank;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    //Enough tasks ?
    if (size < 2) {
        std::cerr << "This test needs at least 2 processes!" << std::endl;
        MPI_Finalize();
        return 1;
    }

    //Say hello
    std::cout << "Hello, I am rank " << rank << " of " << size << " processes." << std::endl;

    MPI_Comm intracomm;
    //intercomm merge
    MPI_Intercomm_merge(MPI_COMM_WORLD, 1, &intracomm);

    if (intracomm != MPI_COMM_NULL)
        MPI_Comm_free(&intracomm);
    //Say bye bye
    std::cout << "Signing off, rank " << rank << "." << std::endl;

    MPI_Finalize();

    return 0;
}
