/* Part of the MUST Project, under BSD-3-Clause License
 * See https://hpc.rwth-aachen.de/must/LICENSE for license information.
 * SPDX-License-Identifier: BSD-3-Clause
 */

// UNSUPPORTED: fast-tests

// RUN: %compile-cc
// RUN: %must-run %mpiexec-numproc-flag 2 \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck --check-prefix 'CHECK-LOCAL' %s

// RUN: %gen-layout 2 %must-src/cmakemodules/layoutDCollectiveMatch.xml %t.xml
// RUN: %must-run %mpiexec-numproc-flag 2 --must:layout \
// RUN: %t.xml \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck --check-prefix 'CHECK-DISTRIBUTED-LAYOUT' %s

// CHECK-LOCAL: [MUST-REPORT]{{.*A collective mismatch occured [(]The application executes two different collective calls on the same communicator}}

// CHECK-DISTRIBUTED-LAYOUT: [MUST-REPORT]{{.*A collective mismatch occured [(]The application executes two different collective calls on the same communicator}}

/**
 * @file collFenceMissmatchError.c
 * A test with a collective mismatch (Error).
 *
 * Description:
 * MisplacedCall-MpiWinFence-2 test from MPICorrBench
 *
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <stdio.h>

int main(int argc, char** argv)
{
    int rank, size;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    //Enough tasks ?
    if (size < 2) {
        printf("This test needs at least 2 processes!\n");
        MPI_Finalize();
        return 1;
    }

    MPI_Win win;
    int* win_buffer;
    MPI_Win_allocate(
        10 * sizeof(int),
        sizeof(int),
        MPI_INFO_NULL,
        MPI_COMM_WORLD,
        &win_buffer,
        &win);

    if (rank == 0) {
        MPI_Win_fence(0, win);
        MPI_Barrier(MPI_COMM_WORLD);
        int local_buf[10] = {0};
        MPI_Put(&local_buf, 10, MPI_INT, 1, 0, 10, MPI_INT, win);
        MPI_Win_fence(0, win);
    } else {
        MPI_Barrier(MPI_COMM_WORLD);
        MPI_Win_fence(0, win);
        MPI_Win_fence(0, win);
    }

    MPI_Win_free(&win);
    MPI_Finalize();

    return 0;
}
