// RUN: %compile-cxx
// RUN: %must-run %mpiexec-numproc-flag 4 --must:fanin 2 \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck %s

// CHECK: [MUST-REPORT]{{.*Two neighborhood collective calls cause a type mismatch!}}

/**
 * @file NbrAllgatherTypeMatchError.cpp
 * Type matching checks for MPI_Neighbor_allgatherv neigborhood collective
 *
 * Description:
 * Type mismatch due to sending MPI_DOUBLEs but receiving MPI_LONGs (Error)
 * 
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <iostream>
#include <vector>

int main(int argc, char** argv)
{
    MPI_Init(&argc, &argv);

    int world_rank, world_size;
    MPI_Comm_rank(MPI_COMM_WORLD, &world_rank);
    MPI_Comm_size(MPI_COMM_WORLD, &world_size);

    int dims[2] = {0, 0};
    MPI_Dims_create(world_size, 2, dims);
    int periods[2] = {1, 1}; // Periodic in both dimensions
    MPI_Comm cart_comm;
    MPI_Cart_create(MPI_COMM_WORLD, 2, dims, periods, 1, &cart_comm);

    int cart_rank;
    MPI_Comm_rank(cart_comm, &cart_rank);

    std::vector<double> sendbuf = {1, 2, 3, 4};
    std::vector<long> recvbuf(4, -1);
    int recvCounts[4] = {1, 1, 1, 1};
    int displs[4] = {0, 1, 2, 3};
    MPI_Neighbor_allgatherv(
        sendbuf.data(),
        1,
        MPI_DOUBLE,
        recvbuf.data(),
        recvCounts,
        displs,
        MPI_LONG,
        cart_comm);

    MPI_Comm_free(&cart_comm);
    MPI_Finalize();
    return 0;
}