// RUN: %compile-cxx
// RUN: %must-run %mpiexec-numproc-flag 4 --must:fanin 2 \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck --implicit-check-not \
// RUN: '[MUST-REPORT]{{.*(Error|ERROR|Warning|WARNING)}}' %s

/**
 * @file NbrAllgatherTypeMatchLengthNoError.cpp
 * Type length checks for MPI_Neighbor_allgatherv neigborhood collective
 *
 * Description:
 * There is no error in this test case (No-Error)
 * 
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <iostream>
#include <vector>

int main(int argc, char** argv)
{
    MPI_Init(&argc, &argv);

    int world_rank, world_size;
    MPI_Comm_rank(MPI_COMM_WORLD, &world_rank);
    MPI_Comm_size(MPI_COMM_WORLD, &world_size);

    int dims[2] = {0, 0};
    MPI_Dims_create(world_size, 2, dims);
    int periods[2] = {1, 1}; // Periodic in both dimensions
    MPI_Comm cart_comm;
    MPI_Cart_create(MPI_COMM_WORLD, 2, dims, periods, 1, &cart_comm);

    int cart_rank;
    MPI_Comm_rank(cart_comm, &cart_rank);

    std::vector<double> sendbuf = {1, 2, 3, 4, 5, 6, 7, 8};
    std::vector<double> recvbuf(8, -1);
    int recvCounts[4] = {2, 2, 2, 2};
    int displs[4] = {0, 2, 4, 6};
    MPI_Neighbor_allgatherv(
        sendbuf.data(),
        2,
        MPI_DOUBLE,
        recvbuf.data(),
        recvCounts,
        displs,
        MPI_DOUBLE,
        cart_comm);

    MPI_Comm_free(&cart_comm);
    MPI_Finalize();
    return 0;
}