// RUN: %compile-cxx
// RUN: %must-run %mpiexec-numproc-flag 4 --must:fanin 2 \
// RUN: %t.exe 2>&1 \
// RUN: | %filecheck %s

// CHECK: [MUST-REPORT]{{.*}}Two neighborhood collective operations use (datatype,count) pairs that span type signatures of different length!

/**
 * @file NbrAlltoallwTypeMatchLengthError-1.cpp
 * Type length checks for MPI_Neighbor_alltoallw neigborhood collective
 *
 * Description:
 * Type length mismatch due to sending one MPI_DOUBLE but tyring to receiving two MPI_DOUBLEs (Error)
 * 
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <iostream>
#include <vector>

int main(int argc, char** argv)
{
    MPI_Init(&argc, &argv);

    int world_rank, world_size;
    MPI_Comm_rank(MPI_COMM_WORLD, &world_rank);
    MPI_Comm_size(MPI_COMM_WORLD, &world_size);

    int dims[2] = {0, 0};
    MPI_Dims_create(world_size, 2, dims);
    int periods[2] = {1, 1}; // Periodic in both dimensions
    MPI_Comm cart_comm;
    MPI_Cart_create(MPI_COMM_WORLD, 2, dims, periods, 1, &cart_comm);

    int cart_rank;
    MPI_Comm_rank(cart_comm, &cart_rank);

    const int num_neighbors = 4;

    // Send 1 double but try to receive 2 doubles
    std::vector<int> sendcounts(num_neighbors, 1);
    std::vector<int> recvcounts(num_neighbors, 2);
    std::vector<MPI_Aint> sdispls(num_neighbors, 0);
    std::vector<MPI_Aint> rdispls(num_neighbors, 0);
    std::vector<MPI_Datatype> sendtypes(num_neighbors, MPI_DOUBLE);
    std::vector<MPI_Datatype> recvtypes(num_neighbors, MPI_DOUBLE);

    for (int i = 1; i < num_neighbors; ++i) {
        sdispls[i] = sdispls[i - 1] + sendcounts[i - 1] * sizeof(double);
        rdispls[i] = rdispls[i - 1] + recvcounts[i - 1] * sizeof(double);
    }

    if (world_rank == 0) {
        std::cout << "rdispls -- ";
        for (auto& displ : rdispls)
            std::cout << displ << " ";
        std::cout << std::endl;
    }

    std::vector<double> sendbuf(num_neighbors, cart_rank);
    std::vector<double> recvbuf(num_neighbors * 2, -1);

    MPI_Neighbor_alltoallw(
        sendbuf.data(),
        sendcounts.data(),
        sdispls.data(),
        sendtypes.data(),
        recvbuf.data(),
        recvcounts.data(),
        rdispls.data(),
        recvtypes.data(),
        cart_comm);

    MPI_Comm_free(&cart_comm);
    MPI_Finalize();
    return 0;
}