// RUN: %compile-cxx
// RUN: %must-run-ddl %mpiexec-numproc-flag 4 %t.exe 2>&1 | %filecheck %s

// CHECK: [MUST-REPORT]{{.*The application issued a set of MPI calls that can cause a deadlock!}}
// CHECK: MPI_Neighbor_allgather

/**
 * @file NbrAllgatherDl.cpp
 * Test case that uses MPI_Neighbor_allgather calls on a periodic cartesian communicator 
 *
 * Description:
 * Deadlock due to rank 0 not participating in the MPI_Neighbor_allgather collective call (Error)
 *
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <iostream>
#include <vector>

int main(int argc, char** argv)
{
    MPI_Init(&argc, &argv);

    int world_rank, world_size;
    MPI_Comm_rank(MPI_COMM_WORLD, &world_rank);
    MPI_Comm_size(MPI_COMM_WORLD, &world_size);

    int dims[2] = {0, 0};
    MPI_Dims_create(world_size, 2, dims);
    int periods[2] = {1, 1}; // Make cart comm periodic in both dimensions
    MPI_Comm cart_comm;
    MPI_Cart_create(MPI_COMM_WORLD, 2, dims, periods, 1, &cart_comm);

    int cart_rank;
    MPI_Comm_rank(cart_comm, &cart_rank);

    std::vector<int> sendbuf = {cart_rank, cart_rank, cart_rank, cart_rank};
    std::vector<int> recvbuf(4, -1);

    if (world_rank != 0)
        MPI_Neighbor_allgather(sendbuf.data(), 1, MPI_INT, recvbuf.data(), 1, MPI_INT, cart_comm);

    MPI_Comm_free(&cart_comm);
    MPI_Finalize();
    return 0;
}