// RUN: %compile-cxx
// RUN: %must-run-ddl %mpiexec-numproc-flag 4 %t.exe 2>&1 | %filecheck %s

// CHECK: [MUST-REPORT]{{.*The application issued a set of MPI calls that can cause a deadlock!}}
// CHECK: MPI_Neighbor_alltoallv

/**
 * @file NbrAlltoallvDl.cpp
 * Test case that uses MPI_Neighbor_alltoallv calls on a periodic cartesian communicator 
 *
 * Description:
 * Deadlock due to rank 0 not participating in the MPI_Neighbor_alltoallv collective call (Error)
 *
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <iostream>
#include <vector>

int main(int argc, char** argv)
{
    MPI_Init(&argc, &argv);

    int world_rank, world_size;
    MPI_Comm_rank(MPI_COMM_WORLD, &world_rank);
    MPI_Comm_size(MPI_COMM_WORLD, &world_size);

    int dims[2] = {0, 0};
    MPI_Dims_create(world_size, 2, dims);
    int periods[2] = {1, 1}; // Periodic in both dimensions
    MPI_Comm cart_comm;
    MPI_Cart_create(MPI_COMM_WORLD, 2, dims, periods, 1, &cart_comm);

    int cart_rank;
    MPI_Comm_rank(cart_comm, &cart_rank);

    // Assume each process has 4 neighbors (2D periodic grid)
    const int num_neighbors = 4;

    std::vector<int> sendcounts(num_neighbors, 1);
    std::vector<int> recvcounts(num_neighbors, 1);
    std::vector<int> sdispls(num_neighbors, 0);
    std::vector<int> rdispls(num_neighbors, 0);

    for (int i = 1; i < num_neighbors; ++i) {
        sdispls[i] = sdispls[i - 1] + sendcounts[i - 1];
        rdispls[i] = rdispls[i - 1] + recvcounts[i - 1];
    }

    std::vector<int> sendbuf(num_neighbors, cart_rank);
    std::vector<int> recvbuf(num_neighbors, -1);

    if (cart_rank != 0)
        MPI_Neighbor_alltoallv(
            sendbuf.data(),
            sendcounts.data(),
            sdispls.data(),
            MPI_INT,
            recvbuf.data(),
            recvcounts.data(),
            rdispls.data(),
            MPI_INT,
            cart_comm);

    MPI_Comm_free(&cart_comm);
    MPI_Finalize();
    return 0;
}