// RUN: %compile-cxx
// RUN: %must-run-ddl %mpiexec-numproc-flag 4 %t.exe 2>&1 \
// RUN: | %filecheck --implicit-check-not \
// RUN: '[MUST-REPORT]{{.*(Error|ERROR|Warning|WARNING)}}' %s

/**
 * @file NbrAlltoallwNoDl.cpp
 * Test case that uses MPI_Neighbor_alltoallw calls on a periodic cartesian communicator 
 *
 * Description:
 * There is no error in this test case (No-Error)
 *
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <iostream>
#include <vector>

int main(int argc, char** argv)
{
    MPI_Init(&argc, &argv);

    int world_rank, world_size;
    MPI_Comm_rank(MPI_COMM_WORLD, &world_rank);
    MPI_Comm_size(MPI_COMM_WORLD, &world_size);

    int dims[2] = {0, 0};
    MPI_Dims_create(world_size, 2, dims);
    int periods[2] = {1, 1}; // Periodic in both dimensions
    MPI_Comm cart_comm;
    MPI_Cart_create(MPI_COMM_WORLD, 2, dims, periods, 1, &cart_comm);

    int cart_rank;
    MPI_Comm_rank(cart_comm, &cart_rank);

    // Assume each process has 4 neighbors (2D periodic grid)
    const int num_neighbors = 4;

    std::vector<int> sendcounts(num_neighbors, 1);
    std::vector<int> recvcounts(num_neighbors, 1);
    std::vector<MPI_Aint> sdispls(num_neighbors, 0);
    std::vector<MPI_Aint> rdispls(num_neighbors, 0);
    std::vector<MPI_Datatype> sendtypes(num_neighbors, MPI_INT);
    std::vector<MPI_Datatype> recvtypes(num_neighbors, MPI_INT);

    for (int i = 1; i < num_neighbors; ++i) {
        sdispls[i] = sdispls[i - 1] + sendcounts[i - 1] * sizeof(int);
        rdispls[i] = rdispls[i - 1] + recvcounts[i - 1] * sizeof(int);
    }

    std::vector<int> sendbuf(num_neighbors, cart_rank);
    std::vector<int> recvbuf(num_neighbors, -1);

    MPI_Neighbor_alltoallw(
        sendbuf.data(),
        sendcounts.data(),
        sdispls.data(),
        sendtypes.data(),
        recvbuf.data(),
        recvcounts.data(),
        rdispls.data(),
        recvtypes.data(),
        cart_comm);

    MPI_Comm_free(&cart_comm);
    MPI_Finalize();
    return 0;
}