// RUN: %compile-cxx
// RUN: %must-run-ddl %mpiexec-numproc-flag 4 %t.exe 2>&1 | %filecheck %s

// CHECK: [MUST-REPORT]{{.*The application issued a set of MPI calls that can cause a deadlock!}}
// CHECK-DAG: MPI_Bcast
// CHECK-DAG: MPI_Neighbor_allgather

/**
 * @file NbrMixedDl-2.cpp
 *
 * Description:
 * This test case may deadlock due to rank 0 entering the MPI_Bcast before the neighbor 
 * collective and may blocks there even if it is the root process, while other the ranks
 * enter the neighbor collective first and do not reach the MPI_Bcast. (Error)
 * 
 * "Collective operations can (but are not required to) complete as soon as the caller’s 
 * participation in the collective communication is finished." - MPI 4.1 standard p.190
 * 
 * "A correct, portable program must invoke collective communications so that deadlock 
 * will not occur, whether collective communications are synchronizing or not." 
 * - MPI 4.1 standard p.297
 *
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <iostream>
#include <vector>

int main(int argc, char** argv)
{
    MPI_Init(&argc, &argv);

    int world_rank, world_size;
    MPI_Comm_rank(MPI_COMM_WORLD, &world_rank);
    MPI_Comm_size(MPI_COMM_WORLD, &world_size);

    int dims[2] = {0, 0};
    MPI_Dims_create(world_size, 2, dims);
    int periods[2] = {1, 1}; // Make cart comm periodic in both dimensions
    MPI_Comm cart_comm;
    MPI_Cart_create(MPI_COMM_WORLD, 2, dims, periods, 1, &cart_comm);

    int cart_rank;
    MPI_Comm_rank(cart_comm, &cart_rank);

    std::vector<int> sendBuf = {cart_rank, cart_rank, cart_rank, cart_rank};
    std::vector<int> recvbuf(4, -1);

    int bcastBuf = -1;
    if (world_rank == 0) {
        bcastBuf = 42;
        MPI_Bcast(&bcastBuf, 1, MPI_INT, 0, MPI_COMM_WORLD); // root first
    }

    MPI_Neighbor_allgather(sendBuf.data(), 1, MPI_INT, recvbuf.data(), 1, MPI_INT, cart_comm);

    if (world_rank != 0) {
        MPI_Bcast(&bcastBuf, 1, MPI_INT, 0, MPI_COMM_WORLD);
    }

    MPI_Comm_free(&cart_comm);
    MPI_Finalize();
    return 0;
}