// RUN: %compile-cxx
// RUN: %must-run-ddl %mpiexec-numproc-flag 4 %t.exe 2>&1 \
// RUN: | %filecheck --implicit-check-not \
// RUN: '[MUST-REPORT]{{.*(Error|ERROR|Warning|WARNING)}}' %s

/**
 * @file NbrWaitsomeNoDl.cpp
 * Test case that uses MPI_Waitsome to wait on MPI_Ineighbor_allgather calls
 * on a periodic cartesian communicator 
 *
 * Description:
 * There is no error in this test case (No-Error)
 *
 * @author Cornelius Pätzold
 */

#include <mpi.h>
#include <iostream>
#include <vector>

#define N 4

int main(int argc, char** argv)
{
    MPI_Init(&argc, &argv);

    int world_rank, world_size;
    MPI_Comm_rank(MPI_COMM_WORLD, &world_rank);
    MPI_Comm_size(MPI_COMM_WORLD, &world_size);

    int dims[2] = {0, 0};
    MPI_Dims_create(world_size, 2, dims);
    int periods[2] = {1, 1}; // Make cart comm periodic in both dimensions
    MPI_Comm cart_comm;
    MPI_Cart_create(MPI_COMM_WORLD, 2, dims, periods, 1, &cart_comm);

    int cart_rank;
    MPI_Comm_rank(cart_comm, &cart_rank);

    std::vector<int> sendbuf(4, cart_rank);
    std::vector<std::vector<int>> recvbuf(N, std::vector<int>(4, -1));

    std::vector<MPI_Request> requests(N);
    std::vector<int> indices(N);

    for (int i = 0; i < N; i++) {
        MPI_Ineighbor_allgather(
            sendbuf.data(),
            1,
            MPI_INT,
            recvbuf[i].data(),
            1,
            MPI_INT,
            cart_comm,
            &requests[i]);
    }

    int outCount;
    int sum = 0;
    while (sum < N) {
        MPI_Waitsome(N, requests.data(), &outCount, indices.data(), MPI_STATUS_IGNORE);
        sum += outCount;
    }

    MPI_Comm_free(&cart_comm);
    MPI_Finalize();
    return 0;
}